/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.translation;

import de.tudresden.inf.lat.cel.translation.CelReasonerInterface;
import de.tudresden.inf.lat.cel.translation.UnsupportedQueryException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class OntologyEntailmentChecker
implements OWLAxiomVisitorEx<Boolean> {
    private static final String errorMsg = "Unsupported entailment with axiom:";
    private final CelReasonerInterface reasoner;

    public OntologyEntailmentChecker(CelReasonerInterface reasoner) {
        this.reasoner = reasoner;
    }

    public CelReasonerInterface getReasoner() {
        return this.reasoner;
    }

    public Boolean visit(OWLAnnotationAssertionAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLAnnotationPropertyDomainAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLAnnotationPropertyRangeAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLClassAssertionAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDataPropertyAssertionAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDataPropertyDomainAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDataPropertyRangeAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDatatypeDefinitionAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDeclarationAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDifferentIndividualsAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDisjointClassesAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDisjointDataPropertiesAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDisjointObjectPropertiesAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLDisjointUnionAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLEquivalentClassesAxiom axiom) {
        boolean ret = true;
        Set set = axiom.getClassExpressions();
        if (!set.isEmpty()) {
            OWLClass representative = this.getReasoner().flattenClassExpression((OWLClassExpression)set.iterator().next());
            HashSet<OWLClass> classSet = new HashSet<OWLClass>();
            for (OWLClassExpression classExpr : set) {
                classSet.add(this.getReasoner().flattenClassExpression(classExpr));
            }
            this.getReasoner().precomputeInferences();
            Iterator it = classSet.iterator();
            while (ret && it.hasNext()) {
                OWLClass currentClass = (OWLClass)it.next();
                ret = ret && this.getReasoner().isEquivalentClass((OWLClassExpression)representative, (OWLClassExpression)currentClass);
            }
        }
        return ret;
    }

    public Boolean visit(OWLEquivalentDataPropertiesAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLFunctionalDataPropertyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLFunctionalObjectPropertyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLHasKeyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLInverseObjectPropertiesAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLObjectPropertyAssertionAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLObjectPropertyDomainAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLObjectPropertyRangeAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLReflexiveObjectPropertyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLSameIndividualAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClassExpr = axiom.getSubClass();
        OWLClassExpression superClassExpr = axiom.getSuperClass();
        OWLClass subClass = this.getReasoner().flattenClassExpression(subClassExpr);
        OWLClass superClass = this.getReasoner().flattenClassExpression(superClassExpr);
        this.getReasoner().precomputeInferences();
        boolean ret = this.getReasoner().isSubClassOf((OWLClassExpression)subClass, (OWLClassExpression)superClass);
        return ret;
    }

    public Boolean visit(OWLSubDataPropertyOfAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLSubObjectPropertyOfAxiom axiom) {
        OWLObjectProperty subObjectProp = null;
        OWLObjectProperty superObjectProp = null;
        try {
            subObjectProp = ((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty();
            superObjectProp = ((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty();
        }
        catch (Exception e) {
            throw new UnsupportedQueryException(errorMsg + axiom);
        }
        boolean ret = this.getReasoner().getSuperObjectProperties((OWLObjectPropertyExpression)subObjectProp, false).containsEntity((OWLObject)superObjectProp);
        return ret;
    }

    public Boolean visit(OWLSubPropertyChainOfAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLSymmetricObjectPropertyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(OWLTransitiveObjectPropertyAxiom axiom) {
        throw new UnsupportedQueryException(errorMsg + axiom);
    }

    public Boolean visit(SWRLRule rule) {
        throw new UnsupportedQueryException(errorMsg + rule);
    }
}

