/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.translation;

import de.tudresden.inf.lat.cel.connection.CelConnectionException;
import de.tudresden.inf.lat.cel.connection.CelSocketManager;
import de.tudresden.inf.lat.cel.conversion.CelParser;
import de.tudresden.inf.lat.cel.conversion.CelTranslator;
import de.tudresden.inf.lat.cel.conversion.CelTranslatorException;
import de.tudresden.inf.lat.cel.translation.CelReasonerException;
import de.tudresden.inf.lat.cel.translation.OntologyChangeTracker;
import de.tudresden.inf.lat.cel.translation.OntologyEntailmentChecker;
import de.tudresden.inf.lat.cel.translation.ReachabilityGraph;
import de.tudresden.inf.lat.jsexp.Sexp;
import de.tudresden.inf.lat.jsexp.SexpFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;

public class CelReasonerInterface {
    private static final String auxClassPrefix = "http://lat.inf.tu-dresden.de/systems/cel/auxClass";
    private static final Logger logger = Logger.getLogger(CelReasonerInterface.class.getName());
    private static final String nothing = "Nothing";
    public static final String reasonerName = "CEL";
    private static final String thing = "Thing";
    private int auxClassCount = 0;
    private Map<OWLClassExpression, OWLClass> auxClassInvMap = new HashMap<OWLClassExpression, OWLClass>();
    private Map<OWLClass, OWLClassExpression> auxClassMap = new HashMap<OWLClass, OWLClassExpression>();
    private OntologyChangeTracker changeTracker = new OntologyChangeTracker();
    private OntologyEntailmentChecker entailmentChecker = new OntologyEntailmentChecker(this);
    private OWLOntology ontology = null;
    private CelParser parser = new CelParser();
    private CelSocketManager socketManager = new CelSocketManager();
    private Long timeOut = Long.MAX_VALUE;
    private CelTranslator translator = new CelTranslator();

    public CelReasonerInterface(OWLOntology ontology) {
        this.ontology = ontology;
        this.ontology.getOWLOntologyManager().addOntologyChangeListener((OWLOntologyChangeListener)this.changeTracker);
    }

    public CelReasonerInterface(OWLOntology ontology, OWLReasonerConfiguration config) {
        this(ontology);
        this.getSocketManager().setReasonerConfiguration(config);
    }

    protected void assertSupportedClassExpression(OWLClassExpression expression) throws CelReasonerException {
        try {
            this.getTranslator().translate(expression);
        }
        catch (CelTranslatorException e) {
            throw new CelReasonerException(e);
        }
    }

    protected Sexp convertNil(Sexp expr) {
        Sexp nilExpr = SexpFactory.newAtomicSexp((String)"nil");
        Sexp listOfNilExpr = SexpFactory.newNonAtomicSexp();
        listOfNilExpr.add(nilExpr);
        Sexp ret = expr;
        if (ret.toString().equalsIgnoreCase(nilExpr.toString())) {
            ret = SexpFactory.newNonAtomicSexp();
        } else if (ret.toString().equalsIgnoreCase(listOfNilExpr.toString())) {
            ret = SexpFactory.newNonAtomicSexp();
            ret.add(SexpFactory.newNonAtomicSexp());
        }
        return ret;
    }

    protected NodeSet<OWLClass> convertToNodeSetOfOWLClass(Set<Set<OWLClass>> setOfSets) {
        HashSet<DefaultNode> nodeSet = new HashSet<DefaultNode>();
        for (Set<OWLClass> elem : setOfSets) {
            nodeSet.add(NodeFactory.getOWLClassNode(elem));
        }
        return new OWLClassNodeSet(nodeSet);
    }

    protected NodeSet<OWLNamedIndividual> convertToNodeSetOfOWLNamedIndividual(Set<OWLNamedIndividual> individualSet) {
        HashSet<DefaultNode> nodeSet = new HashSet<DefaultNode>();
        for (OWLNamedIndividual individual : individualSet) {
            nodeSet.add(NodeFactory.getOWLNamedIndividualNode((OWLNamedIndividual)individual));
        }
        return new OWLNamedIndividualNodeSet(nodeSet);
    }

    protected NodeSet<OWLObjectPropertyExpression> convertToNodeSetOfOWLObjectPropertyExpression(Set<Set<OWLObjectPropertyExpression>> setOfSets) {
        HashSet<DefaultNode> nodeSet = new HashSet<DefaultNode>();
        for (Set<OWLObjectPropertyExpression> elem : setOfSets) {
            nodeSet.add(NodeFactory.getOWLObjectPropertyNode(elem));
        }
        return new OWLObjectPropertyNodeSet(nodeSet);
    }

    protected Set<OWLObjectPropertyExpression> convertToOWLObjectPropertyExpression(Set<OWLObjectProperty> set) {
        HashSet<OWLObjectPropertyExpression> ret = new HashSet<OWLObjectPropertyExpression>();
        ret.addAll(set);
        return ret;
    }

    private OWLClass createAuxiliaryClass() {
        IRI iri = IRI.create((String)(auxClassPrefix + this.auxClassCount));
        ++this.auxClassCount;
        OWLClass ret = this.getRootOntology().getOWLOntologyManager().getOWLDataFactory().getOWLClass(iri);
        return ret;
    }

    public void dispose() {
        if (this.getSocketManager() != null) {
            Sexp message = SexpFactory.newNonAtomicSexp();
            message.add(SexpFactory.newAtomicSexp((String)"owlapi.dispose"));
            this.getSocketManager().stopExecution(message);
        }
    }

    protected OWLClass flattenClassExpression(OWLClassExpression ce) {
        OWLClass ret = null;
        if (ce instanceof OWLClass) {
            ret = (OWLClass)ce;
        } else {
            ret = this.auxClassInvMap.get(ce);
            if (ret == null) {
                ret = this.createAuxiliaryClass();
                this.auxClassMap.put(ret, ce);
                this.auxClassInvMap.put(ce, ret);
                HashSet<Object> classExpressions = new HashSet<Object>();
                classExpressions.add(ce);
                classExpressions.add(ret);
                OWLEquivalentClassesAxiom newAxiom = this.getRootOntology().getOWLOntologyManager().getOWLDataFactory().getOWLEquivalentClassesAxiom(classExpressions);
                this.getRootOntology().getOWLOntologyManager().addAxiom(this.getRootOntology(), (OWLAxiom)newAxiom);
            }
        }
        return ret;
    }

    public Node<OWLClass> getBottomClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.getOWLNothing());
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.getOWLBottomObjectProperty());
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression expression) throws CelReasonerException {
        Set<OWLClass> ret = null;
        Sexp message = SexpFactory.newNonAtomicSexp();
        try {
            message.add(SexpFactory.newAtomicSexp((String)"owlapi.get-equivalent-classes"));
            message.add(this.getTranslator().translate(expression));
        }
        catch (CelTranslatorException e) {
            throw new CelReasonerException(e);
        }
        Sexp response = this.sendAndConvert(message);
        ret = this.getParser().parseSetOfClasses(response, this.getOWLOntologyManager().getOWLDataFactory());
        return NodeFactory.getOWLClassNode(ret);
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression propertyExpression) throws CelReasonerException {
        Set<OWLObjectPropertyExpression> ret = null;
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.get-equivalent-properties"));
        message.add(this.getTranslator().translate((OWLObjectPropertyExpression)propertyExpression.asOWLObjectProperty()));
        Sexp response = this.sendAndConvert(message);
        ret = this.convertToOWLObjectPropertyExpression(this.getParser().parseSetOfProperties(response, this.getOWLOntologyManager().getOWLDataFactory()));
        return NodeFactory.getOWLObjectPropertyNode(ret);
    }

    protected Set<OWLObjectProperty> getFlattenedAncestorProperties(OWLObjectProperty property) throws CelReasonerException {
        return this.getSetOfProperties("owlapi.get-flattened-ancestor-properties", property);
    }

    protected Set<OWLObjectProperty> getFlattenedDescendantProperties(OWLObjectProperty property) throws CelReasonerException {
        return this.getSetOfProperties("owlapi.get-flattened-descendant-properties", property);
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression expression, boolean direct) throws CelReasonerException {
        HashSet<OWLNamedIndividual> ret = new HashSet();
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.get-individuals"));
        try {
            message.add(this.getTranslator().translate(expression));
        }
        catch (CelTranslatorException e) {
            throw new CelReasonerException(e);
        }
        message.add(this.getTranslator().translate(direct));
        Sexp expr = this.sendAndConvert(message);
        if (expr.toString().equalsIgnoreCase("nil")) {
            expr = SexpFactory.newNonAtomicSexp();
        }
        ret = this.getParser().parseSetOfIndividuals(expr, this.getOWLOntologyManager().getOWLDataFactory());
        return this.convertToNodeSetOfOWLNamedIndividual(ret);
    }

    public OWLObjectProperty getOWLBottomObjectProperty() {
        return this.getRootOntology().getOWLOntologyManager().getOWLDataFactory().getOWLBottomObjectProperty();
    }

    public OWLClass getOWLNothing() {
        return this.getRootOntology().getOWLOntologyManager().getOWLDataFactory().getOWLNothing();
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.ontology.getOWLOntologyManager();
    }

    public OWLClass getOWLThing() {
        return this.getRootOntology().getOWLOntologyManager().getOWLDataFactory().getOWLThing();
    }

    public OWLObjectProperty getOWLTopObjectProperty() {
        return this.getRootOntology().getOWLOntologyManager().getOWLDataFactory().getOWLTopObjectProperty();
    }

    public CelParser getParser() {
        return this.parser;
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return Collections.emptySet();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return Collections.emptySet();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return Collections.emptyList();
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        return Collections.singleton(InferenceType.CLASS_HIERARCHY);
    }

    public OWLReasonerConfiguration getReasonerConfiguration() {
        return this.socketManager.getReasonerConfiguration();
    }

    public String getReasonerName() {
        return reasonerName;
    }

    public Version getReasonerVersion() {
        Version ret = new Version(0, 0, 0, 0);
        String versionId = CelReasonerInterface.class.getPackage().getImplementationVersion();
        if (versionId != null) {
            StringTokenizer stok = new StringTokenizer(versionId, ".");
            int major = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
            int minor = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
            int patch = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
            int build = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
            ret = new Version(major, minor, patch, build);
        }
        return ret;
    }

    public OWLOntology getRootOntology() {
        return this.ontology;
    }

    protected Set<OWLObjectProperty> getSetOfProperties(String command, OWLClassExpression expression) throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        try {
            message.add(SexpFactory.newAtomicSexp((String)command));
            message.add(this.getTranslator().translate(expression));
        }
        catch (CelTranslatorException e) {
            throw new CelReasonerException(e);
        }
        Sexp response = this.sendAndConvert(message);
        Set<OWLObjectProperty> ret = this.getParser().parseSetOfProperties(response, this.getOWLOntologyManager().getOWLDataFactory());
        return ret;
    }

    protected Set<OWLObjectProperty> getSetOfProperties(String command, OWLObjectProperty property) throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)command));
        message.add(this.getTranslator().translate((OWLObjectPropertyExpression)property));
        Sexp response = this.sendAndConvert(message);
        Set<OWLObjectProperty> ret = this.getParser().parseSetOfProperties(response, this.getOWLOntologyManager().getOWLDataFactory());
        return ret;
    }

    protected Set<Set<OWLClass>> getSetOfSetOfClasses(String command, OWLClassExpression expression) throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        try {
            message.add(SexpFactory.newAtomicSexp((String)command));
            message.add(this.getTranslator().translate(expression));
        }
        catch (CelTranslatorException e) {
            throw new CelReasonerException(e);
        }
        Sexp response = this.sendAndConvert(message);
        Set<Set<OWLClass>> ret = this.getParser().parseSetOfSetOfClasses(response, this.getOWLOntologyManager().getOWLDataFactory());
        return ret;
    }

    protected CelSocketManager getSocketManager() {
        return this.socketManager;
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression classExpression, boolean direct) {
        NodeSet<OWLClass> ret = null;
        ret = direct ? this.convertToNodeSetOfOWLClass(this.getSetOfSetOfClasses("owlapi.get-sub-classes", classExpression)) : this.convertToNodeSetOfOWLClass(this.getSetOfSetOfClasses("owlapi.get-descendant-classes", classExpression));
        return ret;
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression propertyExpression, boolean direct) {
        NodeSet<OWLObjectPropertyExpression> ret = null;
        if (direct) {
            ReachabilityGraph<Set<Object>> graph = new ReachabilityGraph<Set<Object>>();
            Set<OWLObjectProperty> reachableVertices = this.getFlattenedDescendantProperties(propertyExpression.asOWLObjectProperty());
            graph.addReachable((Set<Object>)propertyExpression.asOWLObjectProperty(), (Set<Object>)reachableVertices);
            for (OWLObjectProperty vertex : reachableVertices) {
                graph.addReachable((Set<Object>)vertex, (Set<Object>)this.getFlattenedDescendantProperties(vertex));
            }
            ret = this.convertToNodeSetOfOWLObjectPropertyExpression(this.makeEquivalentClasses(this.convertToOWLObjectPropertyExpression(graph.getDirectSuccessors((Set<Object>)propertyExpression.asOWLObjectProperty()))));
        } else {
            ret = this.convertToNodeSetOfOWLObjectPropertyExpression(this.makeEquivalentClasses(this.convertToOWLObjectPropertyExpression(this.getFlattenedDescendantProperties(propertyExpression.asOWLObjectProperty()))));
        }
        return ret;
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression classExpression, boolean direct) {
        NodeSet<OWLClass> ret = null;
        ret = direct ? this.convertToNodeSetOfOWLClass(this.getSetOfSetOfClasses("owlapi.get-super-classes", classExpression)) : this.convertToNodeSetOfOWLClass(this.getSetOfSetOfClasses("owlapi.get-ancestor-classes", classExpression));
        return ret;
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression propertyExpression, boolean direct) {
        NodeSet<OWLObjectPropertyExpression> ret = null;
        if (direct) {
            ReachabilityGraph<Set<Object>> graph = new ReachabilityGraph<Set<Object>>();
            Set<OWLObjectProperty> reachableVertices = this.getFlattenedAncestorProperties(propertyExpression.asOWLObjectProperty());
            graph.addReachable((Set<Object>)propertyExpression.asOWLObjectProperty(), (Set<Object>)reachableVertices);
            for (OWLObjectProperty vertex : reachableVertices) {
                graph.addReachable((Set<Object>)vertex, (Set<Object>)this.getFlattenedAncestorProperties(vertex));
            }
            ret = this.convertToNodeSetOfOWLObjectPropertyExpression(this.makeEquivalentClasses(this.convertToOWLObjectPropertyExpression(graph.getDirectSuccessors((Set<Object>)propertyExpression.asOWLObjectProperty()))));
        } else {
            ret = this.convertToNodeSetOfOWLObjectPropertyExpression(this.makeEquivalentClasses(this.convertToOWLObjectPropertyExpression(this.getFlattenedAncestorProperties(propertyExpression.asOWLObjectProperty()))));
        }
        return ret;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public Node<OWLClass> getTopClassNode() {
        return this.getEquivalentClasses((OWLClassExpression)this.getOWLThing());
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        return this.getEquivalentObjectProperties((OWLObjectPropertyExpression)this.getOWLTopObjectProperty());
    }

    public CelTranslator getTranslator() {
        return this.translator;
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual individual, boolean direct) throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.get-types"));
        message.add(this.getTranslator().translate(individual));
        message.add(this.getTranslator().translate(direct));
        Sexp response = this.sendAndConvert(message);
        Set<Set<OWLClass>> ret = this.getParser().parseSetOfSetOfClasses(response, this.getOWLOntologyManager().getOWLDataFactory());
        return this.convertToNodeSetOfOWLClass(ret);
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws CelReasonerException {
        Set<Object> ret = new HashSet();
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.get-inconsistent-classes"));
        Sexp expr = this.sendAndConvert(message);
        if (expr.toString().equalsIgnoreCase("nil")) {
            expr = SexpFactory.newNonAtomicSexp();
        }
        ret = this.getParser().parseSetOfClasses(expr, this.getOWLOntologyManager().getOWLDataFactory());
        return NodeFactory.getOWLClassNode(ret);
    }

    public boolean isClassified() throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.is-classified"));
        Sexp response = this.send(message);
        boolean ret = this.getParser().parseBoolean(response);
        return ret;
    }

    public boolean isConsistent() throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.is-consistent"));
        Sexp response = this.send(message);
        boolean ret = this.getParser().parseBoolean(response);
        return ret;
    }

    public boolean isDefined(OWLClass cls) {
        boolean ret = false;
        ret = cls.toString().equals(thing) || cls.toString().equals(nothing) ? true : this.ontology != null && this.ontology.containsClassInSignature(cls.getIRI());
        return ret;
    }

    public boolean isDefined(OWLNamedIndividual individual) {
        return this.ontology != null && this.ontology.containsIndividualInSignature(individual.getIRI());
    }

    public boolean isDefined(OWLObjectProperty property) {
        return this.ontology != null && this.ontology.containsObjectPropertyInSignature(property.getIRI());
    }

    public boolean isEntailed(Set<OWLAxiom> axioms) {
        boolean ret = true;
        Iterator<OWLAxiom> it = axioms.iterator();
        while (ret && it.hasNext()) {
            OWLAxiom axiom = it.next();
            ret = ret && (Boolean)axiom.accept((OWLAxiomVisitorEx)this.entailmentChecker) != false;
        }
        return ret;
    }

    public boolean isEquivalentClass(OWLClassExpression expression0, OWLClassExpression expression1) throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        try {
            message.add(SexpFactory.newAtomicSexp((String)"owlapi.is-equivalent-class"));
            message.add(this.getTranslator().translate(expression0));
            message.add(this.getTranslator().translate(expression1));
        }
        catch (CelTranslatorException e) {
            throw new CelReasonerException(e);
        }
        Sexp response = this.send(message);
        boolean ret = this.getParser().parseBoolean(response);
        return ret;
    }

    public boolean isRealised() throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.is-realised"));
        Sexp response = this.send(message);
        boolean ret = this.getParser().parseBoolean(response);
        return ret;
    }

    public boolean isReflexive(OWLObjectProperty property) throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.is-reflexive"));
        message.add(this.getTranslator().translate((OWLObjectPropertyExpression)property));
        Sexp response = this.send(message);
        boolean ret = this.getParser().parseBoolean(response);
        return ret;
    }

    public boolean isSatisfiable(OWLClassExpression expression) throws CelReasonerException {
        boolean ret = false;
        Sexp message = SexpFactory.newNonAtomicSexp();
        try {
            message.add(SexpFactory.newAtomicSexp((String)"owlapi.is-satisfiable"));
            message.add(this.getTranslator().translate(expression));
        }
        catch (CelTranslatorException e) {
            throw new CelReasonerException(e);
        }
        Sexp response = this.send(message);
        ret = this.getParser().parseBoolean(response);
        return ret;
    }

    public boolean isSubClassOf(OWLClassExpression expression0, OWLClassExpression expression1) throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        try {
            message.add(SexpFactory.newAtomicSexp((String)"owlapi.is-sub-class-of"));
            message.add(this.getTranslator().translate(expression0));
            message.add(this.getTranslator().translate(expression1));
        }
        catch (CelTranslatorException e) {
            throw new CelReasonerException(e);
        }
        Sexp response = this.send(message);
        boolean ret = this.getParser().parseBoolean(response);
        return ret;
    }

    public boolean isTransitive(OWLObjectProperty property) throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.is-transitive"));
        message.add(this.getTranslator().translate((OWLObjectPropertyExpression)property));
        Sexp response = this.send(message);
        boolean ret = this.getParser().parseBoolean(response);
        return ret;
    }

    public void loadOntologies(Set<OWLOntology> setOfOntologies) throws CelReasonerException {
        this.setOntologies(setOfOntologies);
        this.synchronizedIfChanged();
    }

    protected Set<Set<OWLObjectPropertyExpression>> makeEquivalentClasses(Set<OWLObjectPropertyExpression> flattenedSet) throws CelReasonerException {
        HashSet<Set<OWLObjectPropertyExpression>> ret = new HashSet<Set<OWLObjectPropertyExpression>>();
        HashSet visited = new HashSet();
        for (OWLObjectPropertyExpression property : flattenedSet) {
            if (visited.contains(property)) continue;
            Set equivalentProperties = this.getEquivalentObjectProperties(property).getEntities();
            ret.add(equivalentProperties);
            visited.addAll(equivalentProperties);
        }
        return ret;
    }

    public void precomputeInferences() throws CelReasonerException {
        this.synchronizedIfChanged();
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.classify"));
        this.send(message, "Classifying ontology ...");
    }

    public void realise() throws CelReasonerException {
        Sexp message = SexpFactory.newNonAtomicSexp();
        message.add(SexpFactory.newAtomicSexp((String)"owlapi.realise"));
        this.send(message);
    }

    protected Sexp send(Sexp message) throws CelReasonerException {
        Sexp ret = null;
        try {
            ret = this.getSocketManager().send(message);
        }
        catch (CelConnectionException e) {
            throw new CelReasonerException(e);
        }
        return ret;
    }

    protected Sexp send(Sexp message, String title) throws CelReasonerException {
        logger.fine(title);
        if (this.getReasonerConfiguration() != null && this.getReasonerConfiguration().getProgressMonitor() != null) {
            this.getReasonerConfiguration().getProgressMonitor().reasonerTaskStarted(title);
        }
        Sexp ret = this.send(message);
        if (this.getReasonerConfiguration() != null && this.getReasonerConfiguration().getProgressMonitor() != null) {
            this.getReasonerConfiguration().getProgressMonitor().reasonerTaskStopped();
        }
        return ret;
    }

    protected Sexp sendAndConvert(Sexp message) throws CelReasonerException {
        return this.convertNil(this.send(message));
    }

    protected void setOntologies(Set<OWLOntology> setOfOntologies) {
        this.ontology = setOfOntologies.iterator().next();
        this.changeTracker.setOntologyChanged(true);
    }

    public void setProgressMonitor(OWLReasonerConfiguration config) {
        this.getSocketManager().setReasonerConfiguration(config);
    }

    public void synchronizedIfChanged() throws CelReasonerException {
        if (this.changeTracker.getOntologyChanged()) {
            Sexp message = SexpFactory.newNonAtomicSexp();
            message.add(SexpFactory.newAtomicSexp((String)"owlapi.clear-ontologies"));
            this.send(message, "Clearing ontologies ...");
            message = SexpFactory.newNonAtomicSexp();
            message.add(SexpFactory.newAtomicSexp((String)"owlapi.load-ontologies"));
            Sexp axiomSet = SexpFactory.newNonAtomicSexp();
            try {
                axiomSet.add(this.getTranslator().translate(this.ontology, this.getOWLOntologyManager()));
            }
            catch (CelTranslatorException e) {
                throw new CelReasonerException(e);
            }
            message.add(axiomSet);
            this.send(message, "Loading ontologies ...");
            this.changeTracker.setOntologyChanged(false);
        }
    }
}

