/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.protege;

import de.tudresden.inf.lat.cel.owlapi.CelReasoner;
import de.tudresden.inf.lat.cel.owlapi.OWLReasonerXMLOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.InferenceType;

public class ConsoleStarter {
    private static final Logger logger = Logger.getLogger("de.tudresden.inf.lat.cel");
    private String minihelp = "\nUsage:\njava -cp .:<list of jars> " + this.getClass().getCanonicalName() + " <input ontology file name> <inferred data file name> [<log level>]\n";
    private CelReasoner reasoner = null;

    public static void main(String[] args) throws OWLRendererException, OWLOntologyCreationException, FileNotFoundException {
        boolean helpNeeded = true;
        ConsoleStarter instance = new ConsoleStarter();
        if (args.length > 1) {
            helpNeeded = false;
            Level logLevel = Level.FINE;
            if (args.length > 2) {
                logLevel = Level.parse(args[2]);
            }
            instance.start(new File(args[0]), new File(args[1]), logLevel, System.out);
            instance.stop();
        }
        if (helpNeeded) {
            System.out.println(instance.minihelp);
        }
    }

    public String getMiniHelp() {
        return this.minihelp;
    }

    public void start(File ontologyFile, File inferredFile, Level logLevel, OutputStream logOutput) throws OWLOntologyCreationException, OWLRendererException, FileNotFoundException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.loadOntologyFromOntologyDocument(ontologyFile);
        logger.setLevel(logLevel);
        this.reasoner = new CelReasoner(ontology);
        this.reasoner.precomputeInferences(new InferenceType[0]);
        OWLReasonerXMLOutput xmlDoc = new OWLReasonerXMLOutput(this.reasoner);
        xmlDoc.toXML(new FileOutputStream(inferredFile));
    }

    public void stop() {
        this.reasoner.dispose();
    }
}

