/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.owlapi;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owlapi.owlxml.renderer.OWLXMLWriter;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

public class OWLReasonerXMLOutput {
    private OWLReasoner reasoner = null;
    private OWLXMLWriter writer = null;

    public OWLReasonerXMLOutput(OWLReasoner reasoner) {
        this.reasoner = reasoner;
    }

    private void render() {
        TreeSet classSet = new TreeSet();
        classSet.addAll(this.reasoner.getRootOntology().getClassesInSignature());
        TreeSet propertySet = new TreeSet();
        propertySet.addAll(this.reasoner.getRootOntology().getObjectPropertiesInSignature());
        TreeSet individualSet = new TreeSet();
        individualSet.addAll(this.reasoner.getRootOntology().getIndividualsInSignature());
        this.renderDeclaration(classSet);
        this.renderDeclaration(propertySet);
        this.renderDeclaration(individualSet);
        TreeSet classesToVisit = new TreeSet();
        classesToVisit.addAll(classSet);
        while (!classesToVisit.isEmpty()) {
            OWLClass cls = (OWLClass)classesToVisit.iterator().next();
            classesToVisit.remove(cls);
            Set equivClasses = this.reasoner.getEquivalentClasses((OWLClassExpression)cls).getEntities();
            if (equivClasses.size() > 1) {
                this.renderEquivalentClasses(equivClasses);
            }
            classesToVisit.removeAll(equivClasses);
        }
        TreeSet propertiesToVisit = new TreeSet();
        propertiesToVisit.addAll(propertySet);
        while (!propertiesToVisit.isEmpty()) {
            OWLObjectProperty property = (OWLObjectProperty)propertiesToVisit.iterator().next();
            propertiesToVisit.remove(property);
            Set equivProperties = this.reasoner.getEquivalentObjectProperties((OWLObjectPropertyExpression)property).getEntities();
            if (equivProperties.size() > 1) {
                this.renderEquivalentObjectPropertyExpressions(equivProperties);
            }
            propertiesToVisit.removeAll(equivProperties);
        }
        for (OWLClass subClass : classSet) {
            TreeSet superClasses = new TreeSet();
            superClasses.addAll(this.reasoner.getSuperClasses((OWLClassExpression)subClass, true).getFlattened());
            for (OWLClass superClass : superClasses) {
                this.renderSubClassOf(subClass, superClass);
            }
        }
        for (OWLObjectProperty subProperty : propertySet) {
            TreeSet superProperties = new TreeSet();
            superProperties.addAll(this.reasoner.getSuperObjectProperties((OWLObjectPropertyExpression)subProperty, true).getFlattened());
            for (OWLObjectPropertyExpression superProperty : superProperties) {
                this.renderSubObjectPropertyOf(subProperty.asOWLObjectProperty(), superProperty.asOWLObjectProperty());
            }
        }
        for (OWLClass cls : classSet) {
            TreeSet instances = new TreeSet();
            instances.addAll(this.reasoner.getInstances((OWLClassExpression)cls, true).getFlattened());
            for (OWLNamedIndividual individual : instances) {
                this.renderClassAssertion(cls, individual);
            }
        }
        for (OWLObjectProperty property : propertySet) {
            for (OWLNamedIndividual individual : individualSet) {
                TreeSet propertyValues = new TreeSet();
                propertyValues.addAll(this.reasoner.getObjectPropertyValues(individual, (OWLObjectPropertyExpression)property.asOWLObjectProperty()).getFlattened());
                for (OWLNamedIndividual otherIndividual : propertyValues) {
                    this.renderObjectPropertyAssertion(property, individual, otherIndividual);
                }
            }
        }
    }

    private void renderClassAssertion(OWLClass cls, OWLNamedIndividual individual) {
        this.writer.writeStartElement(OWLXMLVocabulary.CLASS_ASSERTION);
        this.renderEntity((OWLEntity)cls);
        this.renderEntity((OWLEntity)individual);
        this.writer.writeEndElement();
    }

    private void renderDeclaration(Set<? extends OWLEntity> entities) {
        for (OWLEntity oWLEntity : entities) {
            this.writer.writeStartElement(OWLXMLVocabulary.DECLARATION);
            this.renderEntity(oWLEntity);
            this.writer.writeEndElement();
        }
    }

    private void renderEntity(OWLEntity entity) {
        if (entity instanceof OWLClass) {
            this.writer.writeStartElement(OWLXMLVocabulary.CLASS);
        } else if (entity instanceof OWLObjectProperty) {
            this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY);
        } else if (entity instanceof OWLNamedIndividual) {
            this.writer.writeStartElement(OWLXMLVocabulary.NAMED_INDIVIDUAL);
        } else {
            throw new IllegalStateException("Entity cannot be rendered : '" + entity + "'.");
        }
        this.writer.writeIRIAttribute(entity.getIRI());
        this.writer.writeEndElement();
    }

    private void renderEntitySet(Set<? extends OWLEntity> entitySet) {
        TreeSet<? extends OWLEntity> set = new TreeSet<OWLEntity>();
        set.addAll(entitySet);
        for (OWLEntity oWLEntity : set) {
            this.renderEntity(oWLEntity);
        }
    }

    private void renderEquivalentClasses(Set<OWLClass> classSet) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_CLASSES);
        this.renderEntitySet(classSet);
        this.writer.writeEndElement();
    }

    private void renderEquivalentObjectPropertyExpressions(Set<OWLObjectPropertyExpression> propertySet) {
        this.writer.writeStartElement(OWLXMLVocabulary.EQUIVALENT_OBJECT_PROPERTIES);
        TreeSet<OWLObjectPropertyExpression> set = new TreeSet<OWLObjectPropertyExpression>();
        set.addAll(propertySet);
        for (OWLObjectPropertyExpression propertyExpression : set) {
            this.renderEntity((OWLEntity)propertyExpression.asOWLObjectProperty());
        }
        this.writer.writeEndElement();
    }

    private void renderObjectPropertyAssertion(OWLObjectProperty property, OWLNamedIndividual subject, OWLNamedIndividual object) {
        this.writer.writeStartElement(OWLXMLVocabulary.OBJECT_PROPERTY_ASSERTION);
        this.renderEntity((OWLEntity)property);
        this.renderEntity((OWLEntity)subject);
        this.renderEntity((OWLEntity)object);
        this.writer.writeEndElement();
    }

    private void renderSubClassOf(OWLClass subClass, OWLClass superClass) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_CLASS_OF);
        this.renderEntity((OWLEntity)subClass);
        this.renderEntity((OWLEntity)superClass);
        this.writer.writeEndElement();
    }

    private void renderSubObjectPropertyOf(OWLObjectProperty subProperty, OWLObjectProperty superProperty) {
        this.writer.writeStartElement(OWLXMLVocabulary.SUB_OBJECT_PROPERTY_OF);
        this.renderEntity((OWLEntity)subProperty);
        this.renderEntity((OWLEntity)superProperty);
        this.writer.writeEndElement();
    }

    public void toXML(OutputStream out) throws OWLRendererException {
        OWLOntology ontology = this.reasoner.getRootOntology();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        this.writer = new OWLXMLWriter((Writer)writer, ontology);
        this.writer.startDocument(ontology);
        this.render();
        this.writer.endDocument();
    }
}

