/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.owlapi;

import de.tudresden.inf.lat.cel.owlapi.UnsupportedReasonerOperationInCelException;
import de.tudresden.inf.lat.cel.translation.CelReasonerInterface;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.util.Version;

public class CelReasoner
implements OWLReasoner {
    private static final Logger logger = Logger.getLogger(CelReasoner.class.getName());
    private CelReasonerInterface celInterface = null;
    private Date instanceStart = new Date();
    private final Set<AxiomType<?>> supportedAxiomTypes;

    public CelReasoner(OWLOntology ontology) {
        this.celInterface = new CelReasonerInterface(ontology);
        this.supportedAxiomTypes = this.getSupportedTypes();
    }

    public CelReasoner(OWLOntology ontology, OWLReasonerConfiguration config) {
        this.celInterface = new CelReasonerInterface(ontology, config);
        this.supportedAxiomTypes = this.getSupportedTypes();
    }

    public void dispose() {
        logger.finer("dispose()");
        this.getCelInterface().dispose();
    }

    public void finalize() throws Throwable {
        logger.finer("finalize()");
        this.dispose();
        super.finalize();
    }

    public void flush() {
        logger.finer("flush()");
    }

    public Node<OWLClass> getBottomClassNode() {
        logger.finer("getBottomClassNode()");
        return this.getCelInterface().getBottomClassNode();
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        logger.finer("getBottomDataPropertyNode()");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        logger.finer("getBottomObjectPropertyNode()");
        return this.getCelInterface().getBottomObjectPropertyNode();
    }

    public BufferingMode getBufferingMode() {
        logger.finer("getBufferingMode()");
        return BufferingMode.NON_BUFFERING;
    }

    protected CelReasonerInterface getCelInterface() {
        return this.celInterface;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty property, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getDataPropertyDomains(" + property + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual individual, OWLDataProperty property) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getDataPropertyValues(" + individual + ", " + property + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual individual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getDifferentIndividuals(" + individual + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression classExpression) {
        logger.finer("getDisjointClasses(" + classExpression + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression property) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getDisjointDataProperties(" + property + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getDisjointObjectProperties(" + objectPropertyExpression + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression classExpression) {
        logger.finer("getEquivalentClasses(" + classExpression + ")");
        return this.getCelInterface().getEquivalentClasses(classExpression);
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty property) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getEquivalentDataProperties(" + property + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getEquivalentObjectProperties(" + objectPropertyExpression + ")");
        return this.getCelInterface().getEquivalentObjectProperties(objectPropertyExpression);
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        logger.finer("getFreshEntityPolicy()");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        logger.finer("getIndividualNodeSetPolicy()");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression classExpression, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getInstances(" + classExpression + ", " + direct + ")");
        return this.getCelInterface().getInstances(classExpression, direct);
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getInverseObjectProperties(" + objectPropertyExpression + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getObjectPropertyDomains(" + objectPropertyExpression + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getObjectPropertyRanges(" + objectPropertyExpression + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual individual, OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getObjectPropertyValues(" + individual + ", " + objectPropertyExpression + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        logger.finer("getPendingAxiomAdditions()");
        return this.getCelInterface().getPendingAxiomAdditions();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        logger.finer("getPendingAxiomRemovals()");
        return this.getCelInterface().getPendingAxiomRemovals();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        logger.finer("getPendingChanges()");
        return this.getCelInterface().getPendingChanges();
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        logger.finer("getPrecomputableInferenceTypes()");
        return this.getCelInterface().getPrecomputableInferenceTypes();
    }

    public OWLReasonerConfiguration getReasonerConfiguration() {
        return this.getCelInterface().getReasonerConfiguration();
    }

    public String getReasonerName() {
        logger.finer("getReasonerName()");
        return this.getCelInterface().getReasonerName();
    }

    public Version getReasonerVersion() {
        logger.finer("getReasonerVersion()");
        return this.getCelInterface().getReasonerVersion();
    }

    public OWLOntology getRootOntology() {
        logger.finer("getRootOntology()");
        return this.getCelInterface().getRootOntology();
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual individual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getSameIndividuals(" + individual + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression classExpression, boolean direct) {
        logger.finer("getSubClasses(" + classExpression + ", " + direct + ")");
        return this.getCelInterface().getSubClasses(classExpression, direct);
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty property, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getSubDataProperties(" + property + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getSubObjectProperties(" + objectPropertyExpression + ", " + direct + ")");
        return this.getCelInterface().getSubObjectProperties(objectPropertyExpression, direct);
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression classExpression, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getSuperClasses(" + classExpression + ", " + direct + ")");
        return this.getCelInterface().getSuperClasses(classExpression, direct);
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty dataProperty, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getSuperDataProperties(" + dataProperty + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getSuperObjectProperties(" + objectPropertyExpression + ", " + direct + ")");
        return this.getCelInterface().getSuperObjectProperties(objectPropertyExpression, direct);
    }

    private Set<AxiomType<?>> getSupportedTypes() {
        HashSet<AxiomType> ret = new HashSet<AxiomType>();
        ret.add(AxiomType.EQUIVALENT_CLASSES);
        ret.add(AxiomType.SUBCLASS_OF);
        ret.add(AxiomType.SUB_OBJECT_PROPERTY);
        return Collections.unmodifiableSet(ret);
    }

    public long getTimeOut() {
        logger.finer("getTimeOut()");
        return this.getCelInterface().getTimeOut();
    }

    public Node<OWLClass> getTopClassNode() {
        logger.finer("getTopClassNode()");
        return this.getCelInterface().getTopClassNode();
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        logger.finer("getTopDataPropertyNode()");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        logger.finer("getTopObjectPropertyNode()");
        return this.getCelInterface().getTopObjectPropertyNode();
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual individual, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        logger.finer("getTypes(" + individual + ", " + direct + ")");
        return this.getCelInterface().getTypes(individual, direct);
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        logger.finer("getUnsatisfiableClasses()");
        return this.getCelInterface().getUnsatisfiableClasses();
    }

    public void interrupt() {
        logger.finer("interrupt()");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        logger.finer("isConsistent()");
        return this.getCelInterface().isConsistent();
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        logger.finer("isEntailed((OWLAxiom) " + axiom + ")");
        boolean ret = this.getCelInterface().isEntailed(Collections.singleton(axiom));
        logger.finer("" + ret);
        return ret;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axiomSet) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        logger.finer("isEntailed((Set<? extends OWLAxiom>) " + axiomSet + ")");
        HashSet<OWLAxiom> set = new HashSet<OWLAxiom>();
        for (OWLAxiom oWLAxiom : axiomSet) {
            set.add(oWLAxiom);
        }
        boolean ret = this.getCelInterface().isEntailed(set);
        logger.finer("" + ret);
        return ret;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        logger.finer("isEntailmentCheckingSupported(" + axiomType + ")");
        boolean ret = this.supportedAxiomTypes.contains(axiomType);
        logger.finer("" + ret);
        return ret;
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        logger.finer("isPrecomputed(" + inferenceType + ")");
        throw new UnsupportedReasonerOperationInCelException();
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) {
        logger.finer("isSatisfiable(" + classExpression + ")");
        return this.getCelInterface().isSatisfiable(classExpression);
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) {
        logger.finer("precomputeInferences(" + inferenceTypes + ")");
        Date start = new Date();
        this.getCelInterface().precomputeInferences();
        Date end = new Date();
        if (logger.isLoggable(Level.CONFIG)) {
            System.out.println(" (" + (end.getTime() - this.instanceStart.getTime()) + " ms) " + "\tCEL classified in  " + (end.getTime() - start.getTime()) + " ms ");
        }
    }
}

