/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.conversion;

import de.tudresden.inf.lat.cel.conversion.CelTranslatorException;
import de.tudresden.inf.lat.jsexp.Sexp;
import de.tudresden.inf.lat.jsexp.SexpFactory;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;

public class CelTranslator {
    protected Sexp createAtomicSymbol(IRI iri) {
        return this.createAtomicSymbol(iri.toString());
    }

    protected Sexp createAtomicSymbol(String symbol) {
        Sexp ret = SexpFactory.newAtomicSexp((String)("|" + symbol + '|'));
        return ret;
    }

    protected boolean isIgnoredAxiom(OWLAxiom axiom) {
        boolean ret = axiom instanceof OWLDeclarationAxiom || axiom instanceof OWLAnnotationAssertionAxiom;
        return ret;
    }

    public Sexp translate(boolean boolval) {
        return boolval ? SexpFactory.newAtomicSexp((String)"t") : SexpFactory.newAtomicSexp((String)"nil");
    }

    public Sexp translate(OWLAxiom axiom) throws CelTranslatorException {
        Sexp ret = null;
        if (axiom instanceof OWLClassAssertionAxiom) {
            ret = this.translateAxiom((OWLClassAssertionAxiom)axiom);
        } else if (axiom instanceof OWLDifferentIndividualsAxiom) {
            ret = this.translateAxiom((OWLDifferentIndividualsAxiom)axiom);
        } else if (axiom instanceof OWLDisjointClassesAxiom) {
            ret = this.translateAxiom((OWLDisjointClassesAxiom)axiom);
        } else if (axiom instanceof OWLEquivalentClassesAxiom) {
            ret = this.translateAxiom((OWLEquivalentClassesAxiom)axiom);
        } else if (axiom instanceof OWLEquivalentObjectPropertiesAxiom) {
            ret = this.translateAxiom((OWLEquivalentObjectPropertiesAxiom)axiom);
        } else if (axiom instanceof OWLObjectPropertyAssertionAxiom) {
            ret = this.translateAxiom((OWLObjectPropertyAssertionAxiom)axiom);
        } else if (axiom instanceof OWLSubPropertyChainOfAxiom) {
            ret = this.translateAxiom((OWLSubPropertyChainOfAxiom)axiom);
        } else if (axiom instanceof OWLObjectPropertyDomainAxiom) {
            ret = this.translateAxiom((OWLObjectPropertyDomainAxiom)axiom);
        } else if (axiom instanceof OWLObjectPropertyRangeAxiom) {
            ret = this.translateAxiom((OWLObjectPropertyRangeAxiom)axiom);
        } else if (axiom instanceof OWLSubObjectPropertyOfAxiom) {
            ret = this.translateAxiom((OWLSubObjectPropertyOfAxiom)axiom);
        } else if (axiom instanceof OWLReflexiveObjectPropertyAxiom) {
            ret = this.translateAxiom((OWLReflexiveObjectPropertyAxiom)axiom);
        } else if (axiom instanceof OWLSameIndividualAxiom) {
            ret = this.translateAxiom((OWLSameIndividualAxiom)axiom);
        } else if (axiom instanceof OWLSubClassOfAxiom) {
            ret = this.translateAxiom((OWLSubClassOfAxiom)axiom);
        } else if (axiom instanceof OWLTransitiveObjectPropertyAxiom) {
            ret = this.translateAxiom((OWLTransitiveObjectPropertyAxiom)axiom);
        }
        if (ret == null) {
            throw new CelTranslatorException("OWLAxiom '" + axiom.toString() + "' is not supported.");
        }
        return ret;
    }

    public Sexp translate(OWLClassExpression description) throws CelTranslatorException {
        Sexp ret = null;
        if (description.isOWLThing()) {
            ret = SexpFactory.newAtomicSexp((String)"top");
        } else if (description.isOWLNothing()) {
            ret = SexpFactory.newAtomicSexp((String)"bottom");
        } else if (description instanceof OWLObjectIntersectionOf) {
            ret = this.translateDescription((OWLObjectIntersectionOf)description);
        } else if (description instanceof OWLObjectSomeValuesFrom) {
            ret = this.translateDescription((OWLObjectSomeValuesFrom)description);
        } else if (description instanceof OWLClass) {
            ret = this.translateDescription((OWLClass)description);
        }
        if (ret == null) {
            throw new CelTranslatorException("OWLClassExpression '" + description.toString() + "' is not supported.");
        }
        return ret;
    }

    public Sexp translate(OWLNamedIndividual individual) {
        Sexp ret = this.createAtomicSymbol(individual.getIRI());
        return ret;
    }

    public Sexp translate(OWLObjectPropertyExpression property) {
        Sexp ret = this.translateProperty(property.asOWLObjectProperty());
        return ret;
    }

    public Sexp translate(OWLOntology ontology, OWLOntologyManager ontologyManager) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        Set axioms = ontology.getAxioms();
        for (OWLAxiom axiom : axioms) {
            if (this.isIgnoredAxiom(axiom)) continue;
            ret.add(this.translate(axiom));
        }
        return ret;
    }

    protected Sexp translateAxiom(OWLClassAssertionAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"instance"));
        ret.add(this.translate(axiom.getIndividual().asOWLNamedIndividual()));
        ret.add(this.translate(axiom.getClassExpression()));
        return ret;
    }

    protected Sexp translateAxiom(OWLDifferentIndividualsAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"different-individuals"));
        for (OWLIndividual elem : axiom.getIndividuals()) {
            ret.add(this.translate(elem.asOWLNamedIndividual()));
        }
        return ret;
    }

    protected Sexp translateAxiom(OWLDisjointClassesAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"disjoint"));
        for (OWLClassExpression elem : axiom.getClassExpressions()) {
            ret.add(this.translate(elem));
        }
        return ret;
    }

    protected Sexp translateAxiom(OWLEquivalentClassesAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"equivalent"));
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            Sexp expr = this.translate(desc);
            ret.add(expr);
        }
        return ret;
    }

    protected Sexp translateAxiom(OWLEquivalentObjectPropertiesAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"role-equivalent"));
        for (OWLObjectPropertyExpression desc : axiom.getProperties()) {
            Sexp expr = this.translate(desc);
            ret.add(expr);
        }
        return ret;
    }

    protected Sexp translateAxiom(OWLObjectPropertyAssertionAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"related"));
        ret.add(this.translate(axiom.getSubject().asOWLNamedIndividual()));
        ret.add(this.translate(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual()));
        ret.add(this.translate((OWLObjectPropertyExpression)axiom.getProperty()));
        return ret;
    }

    protected Sexp translateAxiom(OWLObjectPropertyDomainAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"domain"));
        ret.add(this.translate((OWLObjectPropertyExpression)axiom.getProperty()));
        ret.add(this.translate(axiom.getDomain()));
        return ret;
    }

    protected Sexp translateAxiom(OWLObjectPropertyRangeAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"range"));
        ret.add(this.translate((OWLObjectPropertyExpression)axiom.getProperty()));
        ret.add(this.translate((OWLClassExpression)axiom.getRange()));
        return ret;
    }

    protected Sexp translateAxiom(OWLReflexiveObjectPropertyAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"reflexive"));
        ret.add(this.translate((OWLObjectPropertyExpression)axiom.getProperty()));
        return ret;
    }

    protected Sexp translateAxiom(OWLSameIndividualAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"same-individuals"));
        for (OWLIndividual elem : axiom.getIndividuals()) {
            ret.add(this.translate(elem.asOWLNamedIndividual()));
        }
        return ret;
    }

    protected Sexp translateAxiom(OWLSubClassOfAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"implies"));
        ret.add(this.translate(axiom.getSubClass()));
        ret.add(this.translate(axiom.getSuperClass()));
        return ret;
    }

    protected Sexp translateAxiom(OWLSubObjectPropertyOfAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"role-inclusion"));
        ret.add(this.translate((OWLObjectPropertyExpression)axiom.getSubProperty()));
        ret.add(this.translate((OWLObjectPropertyExpression)axiom.getSuperProperty()));
        return ret;
    }

    protected Sexp translateAxiom(OWLSubPropertyChainOfAxiom axiom) throws CelTranslatorException {
        List propertyList = axiom.getPropertyChain();
        Sexp translatedList = SexpFactory.newNonAtomicSexp();
        translatedList.add(SexpFactory.newAtomicSexp((String)"compose"));
        for (OWLObjectPropertyExpression expr : propertyList) {
            translatedList.add(this.translate(expr));
        }
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"role-inclusion"));
        ret.add(translatedList);
        ret.add(this.translate(axiom.getSuperProperty()));
        return ret;
    }

    protected Sexp translateAxiom(OWLTransitiveObjectPropertyAxiom axiom) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"transitive"));
        ret.add(this.translate((OWLObjectPropertyExpression)axiom.getProperty()));
        return ret;
    }

    protected Sexp translateDescription(OWLClass cl) {
        Sexp ret = this.createAtomicSymbol(cl.getIRI());
        return ret;
    }

    protected Sexp translateDescription(OWLObjectIntersectionOf description) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"and"));
        for (OWLClassExpression elem : description.getOperands()) {
            ret.add(this.translate(elem));
        }
        return ret;
    }

    protected Sexp translateDescription(OWLObjectSomeValuesFrom description) throws CelTranslatorException {
        Sexp ret = SexpFactory.newNonAtomicSexp();
        ret.add(SexpFactory.newAtomicSexp((String)"some"));
        ret.add(this.translate((OWLObjectPropertyExpression)description.getProperty()));
        ret.add(this.translate((OWLClassExpression)description.getFiller()));
        return ret;
    }

    protected Sexp translateProperty(OWLObjectProperty property) {
        Sexp ret = this.createAtomicSymbol(property.getIRI());
        return ret;
    }
}

