/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.conversion;

import de.tudresden.inf.lat.cel.conversion.CelParserException;
import de.tudresden.inf.lat.jsexp.Sexp;
import de.tudresden.inf.lat.jsexp.SexpFactory;
import de.tudresden.inf.lat.jsexp.SexpParserException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;

public class CelParser {
    public OWLClassExpression parse(String str, OWLDataFactory dataFactory) throws CelParserException {
        OWLClassExpression ret = null;
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(str.getBytes()));
        try {
            Sexp expr = SexpFactory.parse((InputStream)in);
            ret = this.parseDescription(expr, dataFactory);
        }
        catch (SexpParserException e) {
            throw new CelParserException(e);
        }
        catch (IOException e) {
            throw new CelParserException(e);
        }
        return ret;
    }

    public boolean parseBoolean(Sexp expr) {
        boolean ret = expr.toString().equalsIgnoreCase("t");
        return ret;
    }

    protected OWLClass parseClass(Sexp expr, OWLDataFactory dataFactory) {
        OWLClass ret = null;
        Sexp cleanExpr = this.removeVbars(expr);
        ret = this.tryToParseBottom(cleanExpr, dataFactory);
        if (ret == null) {
            ret = this.tryToParseTop(cleanExpr, dataFactory);
        }
        if (ret == null) {
            ret = dataFactory.getOWLClass(IRI.create((String)cleanExpr.toString()));
        }
        return ret;
    }

    protected OWLClassExpression parseDescription(Sexp expr, OWLDataFactory dataFactory) throws CelParserException {
        OWLClass ret = null;
        if (expr.isAtomic()) {
            ret = this.parseClass(expr, dataFactory);
        } else {
            ret = this.tryToParseSome(expr, dataFactory);
            if (ret == null) {
                ret = this.tryToParseAnd(expr, dataFactory);
            }
            if (ret == null) {
                throw new CelParserException("'" + expr.toString() + "' was not parsed.");
            }
        }
        return ret;
    }

    public Set<OWLClass> parseSetOfClasses(Sexp expr, OWLDataFactory dataFactory) {
        HashSet<OWLClass> ret = new HashSet<OWLClass>();
        for (Sexp elem : expr) {
            ret.add(this.parseClass(elem, dataFactory));
        }
        return ret;
    }

    public Set<OWLClassExpression> parseSetOfDescriptions(Sexp expr, OWLDataFactory dataFactory) throws CelParserException {
        HashSet<OWLClassExpression> ret = new HashSet<OWLClassExpression>();
        for (Sexp elem : expr) {
            ret.add(this.parseDescription(elem, dataFactory));
        }
        return ret;
    }

    public Set<OWLNamedIndividual> parseSetOfIndividuals(Sexp expr, OWLDataFactory dataFactory) {
        HashSet<OWLNamedIndividual> ret = new HashSet<OWLNamedIndividual>();
        for (Sexp elem : expr) {
            Sexp cleanexpr = this.removeVbars(elem);
            ret.add(dataFactory.getOWLNamedIndividual(IRI.create((String)cleanexpr.toString())));
        }
        return ret;
    }

    public Set<OWLObjectProperty> parseSetOfProperties(Sexp expr, OWLDataFactory dataFactory) {
        HashSet<OWLObjectProperty> ret = new HashSet<OWLObjectProperty>();
        for (Sexp elem : expr) {
            Sexp cleanexpr = this.removeVbars(elem);
            ret.add(dataFactory.getOWLObjectProperty(IRI.create((String)cleanexpr.toString())));
        }
        return ret;
    }

    public Set<Set<OWLClass>> parseSetOfSetOfClasses(Sexp expr, OWLDataFactory dataFactory) {
        HashSet<Set<OWLClass>> ret = new HashSet<Set<OWLClass>>();
        for (Sexp subexpr : expr) {
            HashSet<OWLClass> part = new HashSet<OWLClass>();
            for (Sexp elem : subexpr) {
                part.add(this.parseClass(elem, dataFactory));
            }
            ret.add(part);
        }
        return ret;
    }

    public Set<Set<OWLClassExpression>> parseSetOfSetOfDescriptions(Sexp expr, OWLDataFactory dataFactory) throws CelParserException {
        HashSet<Set<OWLClassExpression>> ret = new HashSet<Set<OWLClassExpression>>();
        for (Sexp subexpr : expr) {
            HashSet<OWLClassExpression> part = new HashSet<OWLClassExpression>();
            for (Sexp elem : subexpr) {
                part.add(this.parseDescription(elem, dataFactory));
            }
            ret.add(part);
        }
        return ret;
    }

    public Set<Set<OWLObjectProperty>> parseSetOfSetOfProperties(Sexp expr, OWLDataFactory dataFactory) {
        HashSet<Set<OWLObjectProperty>> ret = new HashSet<Set<OWLObjectProperty>>();
        for (Sexp subexpr : expr) {
            HashSet<OWLObjectProperty> part = new HashSet<OWLObjectProperty>();
            for (Sexp elem : subexpr) {
                Sexp cleanexpr = this.removeVbars(elem);
                part.add(dataFactory.getOWLObjectProperty(IRI.create((String)cleanexpr.toString())));
            }
            ret.add(part);
        }
        return ret;
    }

    protected Sexp removeVbars(Sexp symbolWithVbars) {
        String text;
        Sexp ret = symbolWithVbars;
        if (symbolWithVbars.isAtomic() && (text = symbolWithVbars.toString()).length() >= 2 && text.startsWith("|") && text.endsWith("|")) {
            ret = SexpFactory.newAtomicSexp((String)text.substring(1, text.length() - 1));
        }
        return ret;
    }

    protected OWLClassExpression tryToParseAnd(Sexp expr, OWLDataFactory dataFactory) throws CelParserException {
        Iterator it;
        Sexp current;
        OWLObjectIntersectionOf ret = null;
        if (!expr.isAtomic() && (current = (Sexp)(it = expr.iterator()).next()).isAtomic() && current.toString().equalsIgnoreCase("and")) {
            HashSet<OWLClassExpression> set = new HashSet<OWLClassExpression>();
            while (it.hasNext()) {
                current = (Sexp)it.next();
                set.add(this.parseDescription(current, dataFactory));
            }
            ret = dataFactory.getOWLObjectIntersectionOf(set);
        }
        return ret;
    }

    protected OWLClass tryToParseBottom(Sexp expr, OWLDataFactory dataFactory) {
        OWLClass ret = null;
        if (expr.isAtomic() && expr.toString().equalsIgnoreCase("bottom")) {
            ret = dataFactory.getOWLNothing();
        }
        return ret;
    }

    protected OWLClassExpression tryToParseSome(Sexp expr, OWLDataFactory dataFactory) throws CelParserException {
        Iterator it;
        Sexp current;
        OWLObjectSomeValuesFrom ret = null;
        if (!expr.isAtomic() && (current = (Sexp)(it = expr.iterator()).next()).isAtomic() && current.toString().equalsIgnoreCase("some")) {
            Sexp role = (Sexp)it.next();
            if (!role.isAtomic()) {
                throw new CelParserException("'" + role.toString() + "'" + "was found but only simple roles are accepted.");
            }
            Sexp cleanexpr = this.removeVbars(role);
            OWLObjectProperty re = dataFactory.getOWLObjectProperty(IRI.create((String)cleanexpr.toString()));
            Sexp concept = (Sexp)it.next();
            if (it.hasNext()) {
                throw new CelParserException("'" + expr + "' 'some' has too many parameters.");
            }
            OWLClassExpression ce = this.parseDescription(concept, dataFactory);
            ret = dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)re, ce);
        }
        return ret;
    }

    protected OWLClass tryToParseTop(Sexp expr, OWLDataFactory dataFactory) {
        OWLClass ret = null;
        if (expr.isAtomic() && expr.toString().equalsIgnoreCase("top")) {
            ret = dataFactory.getOWLThing();
        }
        return ret;
    }
}

