/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.connection;

import de.tudresden.inf.lat.cel.connection.CelConnectionException;
import de.tudresden.inf.lat.cel.connection.CelOutputListener;
import de.tudresden.inf.lat.cel.connection.CelProcessOutputHandler;
import de.tudresden.inf.lat.cel.connection.CelProcessThread;
import de.tudresden.inf.lat.cel.connection.CelSocket;
import de.tudresden.inf.lat.jsexp.Sexp;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;

public class CelSocketManager
implements CelOutputListener {
    public static final String greetingMessage = "\nCEL: [C]lassifier for the Description Logic [E][L]+ \nCopyright (C) 2005-2010: B. Suntisrivaraporn and TU Dresden.\nCEL Plug-in - Copyright (C) 2009-2012: Julian Mendez.\nCEL comes with ABSOLUTELY NO WARRANTY; use at your own risk.\nThis is free software for research and evaluation purposes.\nCommercial use is prohibited; please contact the author.\n";
    private static final Logger logger = Logger.getLogger(CelSocketManager.class.getName());
    private CelSocket celSocket = null;
    private int closingConnectionTime = 1000;
    private OWLReasonerConfiguration configuration = null;
    private int firstPort = 40000;
    private int lastPort = 50000;
    private CelProcessOutputHandler outputHandler = null;
    private CelProcessThread processThread = null;
    private int timeoutForServer = 10000;

    private CelSocket getCelSocket() {
        return this.celSocket;
    }

    public CelProcessOutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    protected Process getProcess() {
        return this.getProcessThread().getProcess();
    }

    protected CelProcessThread getProcessThread() {
        return this.processThread;
    }

    public OWLReasonerConfiguration getReasonerConfiguration() {
        return this.configuration;
    }

    @Override
    public void notifyCancelButtonPressed() {
        this.getOutputHandler().stopExecution();
    }

    @Override
    public void notifyExecutionFinished() {
        if (this.getProcessThread() != null) {
            this.getProcessThread().stopProcess();
        }
    }

    public Sexp send(Sexp message) throws CelConnectionException {
        Sexp response = null;
        if (this.getCelSocket() == null) {
            this.start();
        }
        response = this.getCelSocket().send(message);
        return response;
    }

    public void setReasonerConfiguration(OWLReasonerConfiguration config) {
        this.configuration = config;
        if (this.getOutputHandler() != null) {
            this.getOutputHandler().setReasonerConfiguration(this.configuration);
        }
    }

    public void start() {
        int port = -1;
        ServerSocket server = null;
        boolean found = false;
        for (int index = this.firstPort; !found && index < this.lastPort; ++index) {
            try {
                server = new ServerSocket(index);
                port = index;
                found = true;
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!found) {
            throw new RuntimeException("No available ports between " + this.firstPort + " and " + this.lastPort + ".");
        }
        try {
            server.setSoTimeout(this.timeoutForServer);
            logger.fine("Java CEL server waits for Lisp CEL clients on port " + port + " for " + this.timeoutForServer + " milliseconds.");
            this.processThread = new CelProcessThread(port);
            this.processThread.start();
            Socket connection = server.accept();
            this.celSocket = new CelSocket(connection);
            logger.fine("Java CEL server received a client on port " + port + ".");
            if (logger.isLoggable(Level.CONFIG)) {
                System.out.println(greetingMessage);
            }
            this.outputHandler = new CelProcessOutputHandler(this.getProcess().getInputStream(), System.out);
            this.getOutputHandler().setReasonerConfiguration(this.getReasonerConfiguration());
            this.getOutputHandler().setOutputListener(this);
            this.getOutputHandler().start();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Java CEL server cannot open a client on port " + port + ".", e);
            throw new RuntimeException(e);
        }
    }

    public void stopExecution(Sexp endMessage) {
        if (this.getCelSocket() != null && !this.getCelSocket().getSocket().isClosed()) {
            try {
                try {
                    this.send(endMessage);
                }
                catch (CelConnectionException e) {
                    logger.log(Level.WARNING, "CEL server rejected dispose command.", e);
                }
                Thread.sleep(this.closingConnectionTime);
                this.getCelSocket().getSocket().close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "IO exception", e);
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "interruption", e);
            }
        } else {
            logger.fine("Connection already closed.");
        }
        if (this.getOutputHandler() != null) {
            this.getOutputHandler().stopExecution();
        }
    }
}

