/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.connection;

import de.tudresden.inf.lat.cel.connection.CelConnectionException;
import de.tudresden.inf.lat.jsexp.Sexp;
import de.tudresden.inf.lat.jsexp.SexpFactory;
import de.tudresden.inf.lat.jsexp.SexpParserException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.logging.Logger;

class CelSocket {
    private static final Logger logger = Logger.getLogger(CelSocket.class.getName());
    public static final String protError = ":ERROR";
    public static final String protOther = ":OWLAPI-RETURN";
    public static final String protReturn = ":RETURN";
    public static final String protVoid = ":VOID";
    private Socket socket = null;

    public CelSocket(Socket socket) {
        if (socket == null) {
            throw new IllegalArgumentException("Socket cannot be null.");
        }
        this.socket = socket;
    }

    public void close() throws IOException {
        this.getSocket().close();
    }

    protected Socket getSocket() {
        return this.socket;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Sexp process(Sexp original) throws CelConnectionException {
        Sexp ret = null;
        if (original.getLength() <= 0) throw new CelConnectionException("Unexpected response format: '" + original + "'.");
        String msgid = original.get(0).toString();
        if (msgid.equalsIgnoreCase(protReturn)) {
            return original.get(1);
        }
        if (msgid.equalsIgnoreCase(protError)) {
            logger.fine("error " + original.get(1) + "'.");
            throw new CelConnectionException("Error received: '" + original.get(1) + "'.");
        }
        if (msgid.equalsIgnoreCase(protVoid)) {
            return SexpFactory.newNonAtomicSexp();
        }
        if (!msgid.equalsIgnoreCase(protOther)) throw new CelConnectionException("Message identification not recognized: '" + msgid + "'.");
        return SexpFactory.newNonAtomicSexp();
    }

    public Sexp send(Sexp expr) throws CelConnectionException {
        Sexp ret = null;
        try {
            String request = expr.toString();
            this.getSocket().getOutputStream().write(request.getBytes());
            this.getSocket().getOutputStream().flush();
            Sexp response = SexpFactory.parse((InputStream)new BufferedInputStream(this.getSocket().getInputStream()));
            String str = "sent '" + expr + "'  received '" + response + "'     ";
            logger.finer(str);
            ret = this.process(response);
        }
        catch (IOException e) {
            throw new CelConnectionException(e);
        }
        catch (SexpParserException e) {
            throw new CelConnectionException(e);
        }
        return ret;
    }
}

