/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.connection;

import de.tudresden.inf.lat.cel.connection.CelSocket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class CelProcessThread
extends Thread {
    private static String bundleLocation = "native";
    private static String celCommandLine = "cel -owlapiServer localhost";
    private static final String celImage = "cel.dxl";
    private static final String celMain = "cel";
    private static final String lispLibrary = "libacli817.so";
    private static final String lispLicense = "cel.lic";
    private static final Logger logger = Logger.getLogger(CelProcessThread.class.getName());
    private static String loggingSuffix = "logging";
    private static final String nicePrefix = "nice -n 0";
    private CelSocket celSocket = null;
    private int port = 0;
    private Process process = null;
    private List<File> temporaryFiles = null;
    private int timeGap = 100;

    public CelProcessThread(int port) {
        this.port = port;
    }

    protected List<File> copyFiles(File tempDirectory) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        ret.add(this.decompressFile(bundleLocation, celMain, tempDirectory));
        ret.add(this.decompressFile(bundleLocation, celImage, tempDirectory));
        ret.add(this.decompressFile(bundleLocation, lispLicense, tempDirectory));
        ret.add(this.decompressFile(bundleLocation, lispLibrary, tempDirectory));
        ret.add(tempDirectory);
        return ret;
    }

    protected File createTemporaryDirectory() throws IOException {
        File ret = File.createTempFile(celMain, "");
        ret.delete();
        ret.mkdir();
        ret.deleteOnExit();
        return ret;
    }

    protected File decompressFile(String location, String filename, File directory) throws IOException {
        BufferedInputStream source = new BufferedInputStream(CelProcessThread.class.getClassLoader().getResourceAsStream(location + "/" + filename));
        File ret = new File(directory, filename);
        ret.deleteOnExit();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ret));
        int ch = 0;
        while (ch != -1) {
            ch = source.read();
            if (ch == -1) continue;
            out.write(ch);
        }
        out.flush();
        out.close();
        source.close();
        return ret;
    }

    public CelSocket getCelSocket() {
        return this.celSocket;
    }

    public List<File> getFiles() {
        return this.temporaryFiles;
    }

    public int getPort() {
        return this.port;
    }

    public Process getProcess() {
        return this.process;
    }

    protected boolean isUnixlikePlatform() {
        boolean ret = System.getProperty("file.separator").equals("/") && System.getProperty("path.separator").equals(":") && System.getProperty("line.separator").equals("\n");
        return ret;
    }

    @Override
    public void run() {
        try {
            File celDirectory = this.createTemporaryDirectory();
            this.temporaryFiles = this.copyFiles(celDirectory);
            logger.fine("Creating CEL directory " + celDirectory.getAbsolutePath());
            if (!this.isUnixlikePlatform()) {
                throw new RuntimeException("CEL cannot run on this platform.");
            }
            String command = "chmod +x " + celDirectory.getAbsolutePath() + "/cel";
            logger.fine("Unix-like platform found, running '" + command + "'.");
            Thread.sleep(this.timeGap);
            Runtime.getRuntime().exec(command);
            Thread.sleep(this.timeGap);
            String message = "nice -n 0 " + celDirectory.getAbsolutePath() + System.getProperty("file.separator") + celCommandLine + " " + this.port;
            if (logger.isLoggable(Level.FINER)) {
                message = message + " " + loggingSuffix;
            }
            logger.fine("Trying '" + message + "'.");
            this.process = Runtime.getRuntime().exec(message);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopProcess() {
        if (this.getProcess() != null) {
            this.getProcess().destroy();
            this.process = null;
        }
        if (this.getFiles() != null) {
            for (File tempFile : this.getFiles()) {
                tempFile.delete();
            }
            this.temporaryFiles = null;
        }
    }
}

