/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.cel.connection;

import de.tudresden.inf.lat.cel.connection.CelOutputListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;

class CelProcessOutputHandler
extends Thread {
    public static final char countingChar = '#';
    private static final Logger logger = Logger.getLogger(CelProcessOutputHandler.class.getName());
    private static final int maxProgress = 100;
    private boolean active = false;
    private OWLReasonerConfiguration configuration = null;
    private InputStream input = null;
    private CelOutputListener listener = null;
    private OutputStream output = null;
    private long pollingPeriod = 1000L;

    public CelProcessOutputHandler(InputStream in, OutputStream out) {
        this.input = in;
        this.output = out;
    }

    public CelOutputListener getOutputListener() {
        return this.listener;
    }

    public OWLReasonerConfiguration getReasonerConfiguration() {
        return this.configuration;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void run() {
        try {
            int progress = 0;
            this.active = true;
            while (this.isActive()) {
                Thread.sleep(this.pollingPeriod);
                if (this.input.available() <= 0) continue;
                StringBuffer sbuf = new StringBuffer();
                int ch = 32;
                while (this.isActive() && this.input.available() > 0 && ch != -1) {
                    ch = this.input.read();
                    if (ch == -1) continue;
                    if (this.getReasonerConfiguration() != null && this.getReasonerConfiguration().getProgressMonitor() != null && ch == 35) {
                        this.getReasonerConfiguration().getProgressMonitor().reasonerTaskProgressChanged(progress, 100);
                        ++progress;
                    }
                    sbuf.append((char)ch);
                }
                sbuf.append("\n");
                if (!logger.isLoggable(Level.FINER)) continue;
                this.output.write(sbuf.toString().getBytes());
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Cannot show output.", e);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Process was interrupted.", e);
        }
        if (this.getOutputListener() != null) {
            this.getOutputListener().notifyExecutionFinished();
        }
    }

    public void setOutputListener(CelOutputListener outputListener) {
        this.listener = outputListener;
    }

    public void setReasonerConfiguration(OWLReasonerConfiguration config) {
        this.configuration = config;
    }

    public void stopExecution() {
        this.active = false;
    }
}

