/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jsexp;

class Token {
    public static final char escapeChar = '\\';
    public static final char commentChar = ';';
    public static final char leftParenthesisChar = '(';
    public static final char rightParenthesisChar = ')';
    public static final char quotationMarkChar = '\"';
    public static final char verticalBarChar = '|';
    private StringBuffer sbuf = new StringBuffer();
    private int location = -1;

    public Token() {
    }

    public Token(String str, int loc) {
        if (str == null) {
            throw new IllegalArgumentException("Cannot create a token using a null string.");
        }
        this.sbuf = new StringBuffer(str);
        this.location = loc;
    }

    public void append(char ch) {
        this.sbuf.append(ch);
    }

    public void append(String str) {
        if (str != null) {
            this.sbuf.append(str);
        }
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof Token) {
            Token other = (Token)o;
            ret = this.getText().equals(other.getText()) && this.getLocation() == other.getLocation();
        }
        return ret;
    }

    public int getLocation() {
        return this.location;
    }

    public String getText() {
        return this.sbuf.toString();
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    public boolean isComment() {
        return this.getText().startsWith(";");
    }

    public boolean isLeftParenthesis() {
        return this.getText().equals("(");
    }

    public boolean isQuotationMarkToken() {
        return this.getText().startsWith("\"") && this.getText().endsWith("\"");
    }

    public boolean isRightParenthesis() {
        return this.getText().equals(")");
    }

    public boolean isVerticalBarToken() {
        return this.getText().startsWith("|") && this.getText().endsWith("|");
    }

    public int length() {
        return this.sbuf.length();
    }

    public void setLocation(int loc) {
        this.location = loc;
    }

    public void setText(String str) {
        if (str == null) {
            throw new IllegalArgumentException("Cannot create a token using a null string.");
        }
        this.sbuf = new StringBuffer(str);
    }

    public String toString() {
        return this.getText() + ":" + this.getLocation();
    }
}

