/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jsexp;

import de.tudresden.inf.lat.jsexp.SexpParserException;
import de.tudresden.inf.lat.jsexp.Token;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class SexpTokenizer {
    public static final char escapeChar = '\\';
    public static final char commentChar = ';';
    public static final char leftParenthesisChar = '(';
    public static final char rightParenthesisChar = ')';
    public static final char quotationMarkChar = '\"';
    public static final char verticalBarChar = '|';
    public static final char spaceChar = ' ';
    public static final char returnChar = '\r';
    public static final char newLineChar = '\n';
    public static final char tabChar = '\t';
    private State state = State.SYMBOL;
    private Token currentToken = new Token();
    private List<Token> tokenList = new ArrayList<Token>();
    private int lineNumber = 1;
    private int depth = 0;

    public static List<Token> tokenize(InputStream in) throws SexpParserException, IOException {
        SexpTokenizer tokenizer = new SexpTokenizer();
        boolean finished = false;
        int ch = in.read();
        while (!finished && ch != -1) {
            finished = tokenizer.readChar((char)ch);
            if (finished) continue;
            ch = in.read();
        }
        tokenizer.finalize();
        return tokenizer.getParsedTokens();
    }

    private SexpTokenizer() {
    }

    protected void finalize() throws SexpParserException {
        this.flush();
        if (this.state.equals((Object)State.QMARK) || this.state.equals((Object)State.QMARK_BSLASH)) {
            throw new SexpParserException("Missing quotation mark at line " + this.lineNumber);
        }
        if (this.depth != 0) {
            throw new SexpParserException("Unbalanced parenthesis at line " + this.lineNumber + ".");
        }
    }

    protected void flush() {
        if (this.currentToken.length() > 0) {
            this.currentToken.setLocation(this.lineNumber);
            this.tokenList.add(this.currentToken);
            this.currentToken = new Token();
        }
    }

    protected Token getCurrentToken() {
        return this.currentToken;
    }

    protected List<Token> getParsedTokens() {
        return this.tokenList;
    }

    protected boolean readChar(char ch) {
        boolean ret = false;
        switch (this.state) {
            case SYMBOL: {
                this.readSymbol(ch);
                break;
            }
            case QMARK: {
                this.readQuotationMark(ch);
                break;
            }
            case QMARK_BSLASH: {
                this.readQuotationMarkBackslash(ch);
                break;
            }
            case VBAR: {
                this.readVerticalBar(ch);
                break;
            }
            case VBAR_BSLASH: {
                this.readVerticalBarBackslash(ch);
                break;
            }
            case COMMENT: {
                this.readComment(ch);
            }
        }
        ret = this.depth <= 0 && this.tokenList.size() > 0;
        return ret;
    }

    protected void readComment(char ch) {
        if (ch == '\n') {
            this.flush();
            ++this.lineNumber;
            this.state = State.SYMBOL;
        } else {
            this.currentToken.append(ch);
        }
    }

    protected void readQuotationMark(char ch) {
        this.currentToken.append(ch);
        if (ch == '\n') {
            ++this.lineNumber;
        } else if (ch == '\\') {
            this.state = State.QMARK_BSLASH;
        } else if (ch == '\"') {
            this.flush();
            this.state = State.SYMBOL;
        }
    }

    protected void readQuotationMarkBackslash(char ch) {
        this.currentToken.append(ch);
        if (ch == '\n') {
            ++this.lineNumber;
        }
        this.state = State.QMARK;
    }

    protected void readSymbol(char ch) {
        if (ch == '\n') {
            this.flush();
            ++this.lineNumber;
        } else if (ch == ' ' || ch == '\t' || ch == '\r') {
            this.flush();
        } else if (ch == ';') {
            this.flush();
            this.currentToken.append(ch);
            this.state = State.COMMENT;
        } else if (ch == '(') {
            ++this.depth;
            this.flush();
            this.currentToken.append(ch);
            this.flush();
        } else if (ch == ')') {
            --this.depth;
            this.flush();
            this.currentToken.append(ch);
            this.flush();
        } else if (ch == '\"') {
            this.flush();
            this.currentToken.append(ch);
            this.state = State.QMARK;
        } else if (ch == '|') {
            this.flush();
            this.currentToken.append(ch);
            this.state = State.VBAR;
        } else {
            this.currentToken.append(ch);
        }
    }

    protected void readVerticalBar(char ch) {
        this.currentToken.append(ch);
        if (ch == '\n') {
            ++this.lineNumber;
        } else if (ch == '\\') {
            this.state = State.VBAR_BSLASH;
        } else if (ch == '|') {
            this.flush();
            this.state = State.SYMBOL;
        }
    }

    protected void readVerticalBarBackslash(char ch) {
        this.currentToken.append(ch);
        if (ch == '\n') {
            ++this.lineNumber;
        }
        this.state = State.VBAR;
    }

    private static enum State {
        SYMBOL,
        QMARK,
        QMARK_BSLASH,
        VBAR,
        VBAR_BSLASH,
        COMMENT;

    }
}

