/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jsexp;

import de.tudresden.inf.lat.jsexp.Sexp;
import de.tudresden.inf.lat.jsexp.SexpString;
import de.tudresden.inf.lat.jsexp.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class SexpList
implements Sexp {
    protected static final String newLine = "\n";
    protected static final String tabulation = "  ";
    private int depth = 0;
    private List<Sexp> rep = new ArrayList<Sexp>();

    protected SexpList() {
    }

    @Override
    public void add(Sexp item) {
        if (this.getDepth() < item.getDepth() + 1) {
            this.depth = item.getDepth() + 1;
        }
        this.rep.add(item);
    }

    protected SexpList(List<Token> tokenList) {
        SexpList ret = null;
        Stack<SexpList> stack = new Stack<SexpList>();
        SexpList currentList = new SexpList();
        boolean firstTime = true;
        for (Token tok : tokenList) {
            if (tok.isLeftParenthesis()) {
                if (!firstTime) {
                    stack.push(currentList);
                    currentList = new SexpList();
                }
                firstTime = false;
                continue;
            }
            if (tok.isRightParenthesis()) {
                if (stack.empty()) {
                    ret = currentList;
                    continue;
                }
                SexpList lastList = currentList;
                currentList = (SexpList)stack.pop();
                currentList.add(lastList);
                continue;
            }
            if (tok.isComment()) continue;
            currentList.add(new SexpString(tok.getText()));
        }
        this.rep = ret.rep;
    }

    @Override
    public Sexp get(int index) {
        return this.rep.get(index);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getLength() {
        return this.rep.size();
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public Iterator<Sexp> iterator() {
        return this.rep.iterator();
    }

    @Override
    public String toIndentedString() {
        return this.toIndentedString(this, 0).trim();
    }

    protected String toIndentedString(Sexp expr, int depth) {
        StringBuffer ret0 = new StringBuffer();
        if (expr.isAtomic()) {
            ret0.append(expr.toIndentedString());
        } else if (expr.getLength() == 0) {
            ret0.append('(');
            ret0.append(')');
        } else {
            ret0.append(newLine);
            for (int i = 0; i < depth; ++i) {
                ret0.append(tabulation);
            }
            ret0.append('(');
            Iterator<Sexp> it = expr.iterator();
            while (it.hasNext()) {
                Sexp current = it.next();
                ret0.append(this.toIndentedString(current, depth + 1));
                if (!it.hasNext()) continue;
                ret0.append(' ');
            }
            ret0.append(')');
        }
        return ret0.toString();
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof SexpList) {
            SexpList other = (SexpList)o;
            ret = ((Object)this.rep).equals(other.rep);
        }
        return ret;
    }

    public int hashCode() {
        return ((Object)this.rep).hashCode();
    }

    public String toString() {
        StringBuffer ret0 = new StringBuffer();
        ret0.append('(');
        Iterator<Sexp> it = this.rep.iterator();
        while (it.hasNext()) {
            Sexp expr = it.next();
            ret0.append(expr.toString());
            if (!it.hasNext()) continue;
            ret0.append(' ');
        }
        ret0.append(')');
        return ret0.toString();
    }
}

