/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jsexp;

import de.tudresden.inf.lat.jsexp.Sexp;
import de.tudresden.inf.lat.jsexp.SexpList;
import de.tudresden.inf.lat.jsexp.SexpParserException;
import de.tudresden.inf.lat.jsexp.SexpString;
import de.tudresden.inf.lat.jsexp.SexpTokenizer;
import de.tudresden.inf.lat.jsexp.Token;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class SexpFactory {
    public static Sexp newAtomicSexp(String str) {
        return new SexpString(str);
    }

    public static Sexp newNonAtomicSexp() {
        return new SexpList();
    }

    public static Sexp parse(String str) throws SexpParserException {
        Sexp ret = null;
        try {
            ret = SexpFactory.parse(new ByteArrayInputStream(str.getBytes()));
        }
        catch (IOException e) {
            throw new SexpParserException(e);
        }
        return ret;
    }

    public static Sexp parse(InputStream in) throws SexpParserException, IOException {
        Sexp ret = null;
        List<Token> tokenList = SexpTokenizer.tokenize(in);
        if (tokenList.size() == 0) {
            throw new SexpParserException("Empty expression cannot be parsed.");
        }
        if (tokenList.size() == 1) {
            ret = new SexpString(tokenList.get(0).getText());
        } else if (tokenList.size() > 1) {
            ret = new SexpList(tokenList);
        }
        if (ret == null) {
            throw new SexpParserException("Expression '" + tokenList.toString() + "' cannot be parsed.");
        }
        return ret;
    }
}

