/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public abstract class TimestampUtil {
    public static Timestamp parse(String mediaWikiString) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        long time = 0L;
        try {
            time = sdf.parse(mediaWikiString).getTime();
        }
        catch (ParseException e) {
            // empty catch block
        }
        return new Timestamp(time);
    }

    public static String toMediaWikiString(Timestamp timestamp) {
        String original = timestamp.toString();
        StringBuffer result = new StringBuffer();
        result.append(original.substring(0, 4));
        result.append(original.substring(5, 7));
        result.append(original.substring(8, 10));
        result.append(original.substring(11, 13));
        result.append(original.substring(14, 16));
        result.append(original.substring(17, 19));
        return result.toString();
    }

    public static Timestamp getNextTimestamp(Timestamp previous, long nrDays) {
        return new Timestamp(previous.getTime() + nrDays * 24L * 60L * 60L * 1000L);
    }
}

