/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Strings {
    private Strings() {
    }

    public static boolean find(String str, String regex) {
        return Pattern.compile(regex).matcher(str).find();
    }

    public static boolean lookingAt(String str, String regex) {
        return Pattern.compile(regex).matcher(str).lookingAt();
    }

    public static boolean matches(String str, String regex) {
        return Pattern.compile(regex).matcher(str).matches();
    }

    public static boolean endsWithRegex(String str, String regex) {
        return Strings.matches(str, "(.)*" + regex);
    }

    public static String join(Collection c, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String capitalize(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return s;
    }

    public static boolean isEmpty(String s) {
        return s.length() == 0;
    }

    public static boolean isCapitalized(String s) {
        return Character.isUpperCase(s.charAt(0));
    }

    public static String searchAndReplace(String text, String from_regex, String to) {
        from_regex = Strings.escapeString(from_regex, new char[]{'.', '[', ']', '\\'}, '\\');
        Pattern p = Pattern.compile(from_regex);
        Matcher m = p.matcher(text);
        return m.replaceAll(to);
    }

    public static String escapeString(String s, char[] charsToEscape, char escapeChar) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == escapeChar) {
                result.append(escapeChar);
            } else {
                for (int j = 0; j < charsToEscape.length; ++j) {
                    if (c != charsToEscape[j]) continue;
                    result.append(escapeChar);
                    break;
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String toAscii(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                String result = "?";
                if (c >= '\u00c0' && c <= '\u00c5') {
                    result = "A";
                } else if (c == '\u00c6') {
                    result = "AE";
                } else if (c == '\u00c7') {
                    result = "C";
                } else if (c >= '\u00c8' && c <= '\u00cb') {
                    result = "E";
                } else if (c >= '\u00cc' && c <= '\u00cf') {
                    result = "F";
                } else if (c == '\u00d0') {
                    result = "D";
                } else if (c == '\u00d1') {
                    result = "N";
                } else if (c >= '\u00d2' && c <= '\u00d6') {
                    result = "O";
                } else if (c == '\u00d7') {
                    result = "x";
                } else if (c == '\u00d8') {
                    result = "O";
                } else if (c >= '\u00d9' && c <= '\u00dc') {
                    result = "U";
                } else if (c == '\u00dd') {
                    result = "Y";
                } else if (c >= '\u00e0' && c <= '\u00e5') {
                    result = "a";
                } else if (c == '\u00e6') {
                    result = "ae";
                } else if (c == '\u00e7') {
                    result = "c";
                } else if (c >= '\u00e8' && c <= '\u00eb') {
                    result = "e";
                } else if (c >= '\u00ec' && c <= '\u00ef') {
                    result = "i";
                } else if (c == '\u00f1') {
                    result = "n";
                } else if (c >= '\u00f2' && c <= '\u00f8') {
                    result = "o";
                } else if (c >= '\u00f9' && c <= '\u00fc') {
                    result = "u";
                } else if (c >= '\u00fd' && c <= '\u00ff') {
                    result = "y";
                } else if (c >= '\u2018' && c <= '\u2019') {
                    result = "'";
                } else if (c >= '\u201c' && c <= '\u201e') {
                    result = "\"";
                } else if (c >= '\u0213' && c <= '\u2014') {
                    result = "-";
                } else if (c >= '\u00a2' && c <= '\u00a5') {
                    result = "$";
                } else if (c == '\u2026') {
                    result = ".";
                }
                b.append(result);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String group(String str) {
        return "(" + str + ")";
    }

    public static String repeat(String s, int times) {
        if (times == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(Object[] elements, String glue) {
        return Strings.join(Arrays.asList(elements), glue);
    }
}

