/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Redirects {
    private static final Logger log4j = Logger.getLogger(Redirects.class);
    private static final List<String> redirectPatterns = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("#REDIRECT");
            this.add("#WEITERLEITUNG");
        }
    };

    private Redirects() {
    }

    public static boolean isRedirect(String text) {
        boolean result = false;
        for (int i = 0; i < redirectPatterns.size() && !result; ++i) {
            String pattern = redirectPatterns.get(i);
            result = text.regionMatches(true, 0, pattern, 0, pattern.length());
        }
        return result;
    }

    public static String getRedirectDestination(String pageText) {
        String redirectString = null;
        try {
            String regex = "\\[\\[\\s*(.+?)\\s*]]";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(pageText);
            if (matcher.find()) {
                redirectString = matcher.group(1);
            }
            if (redirectString == null) {
                return null;
            }
            String[] anchorSplitValues = redirectString.split("#");
            redirectString = anchorSplitValues[0];
            redirectString = redirectString.trim();
            String[] directSplitValues = redirectString.split("\\|");
            redirectString = directSplitValues[0];
            redirectString = redirectString.trim();
            redirectString = redirectString.trim();
            String regexNamespace = ":([^\\s].+)";
            Pattern patternNamespace = Pattern.compile(regexNamespace);
            Matcher matcherNamespace = patternNamespace.matcher(redirectString);
            if (matcherNamespace.find()) {
                redirectString = matcherNamespace.group(1);
            }
            if ((redirectString = redirectString.replace(" ", "_")).length() > 0) {
                redirectString = redirectString.substring(0, 1).toUpperCase() + redirectString.substring(1, redirectString.length());
            }
        }
        catch (Exception e) {
            redirectString = null;
            log4j.debug((Object)"Error in Redirects ignored");
        }
        return redirectString;
    }
}

