/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Contributor;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.NamespaceSet;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Siteinfo;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Title;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlDumpReader
extends DefaultHandler {
    protected static final String SITENAME = "sitename";
    protected static final String GENERATOR = "generator";
    protected static final String CASE = "case";
    protected static final String BASE = "base";
    protected static final String NAMESPACE = "namespace";
    protected static final String NAMESPACES = "namespaces";
    protected static final String SITEINFO = "siteinfo";
    protected static final String MEDIAWIKI = "mediawiki";
    protected static final String USERNAME = "username";
    protected static final String TITLE = "title";
    protected static final String TIMESTAMP = "timestamp";
    protected static final String TEXT = "text";
    protected static final String RESTRICTIONS = "restrictions";
    protected static final String PAGE = "page";
    protected static final String MINOR = "minor";
    protected static final String IP = "ip";
    protected static final String ID = "id";
    protected static final String COMMENT = "comment";
    protected static final String THREAD_TYPE = "ThreadType";
    protected static final String THREAD_EDIT_STATUS = "ThreadEditStatus";
    protected static final String THREAD_AUTHOR = "ThreadAuthor";
    protected static final String THREAD_SUMMARY_PAGE = "ThreadSummaryPage";
    protected static final String THREAD_ID = "ThreadID";
    protected static final String THREAD_PAGE = "ThreadPage";
    protected static final String THREAD_ANCESTOR = "ThreadAncestor";
    protected static final String THREAD_PARENT = "ThreadParent";
    protected static final String THREAD_SUBJECT = "ThreadSubject";
    protected static final String CONTRIBUTOR = "contributor";
    protected static final String REVISION = "revision";
    InputStream input;
    DumpWriter writer;
    private char[] buffer;
    private int len;
    private boolean hasContent = false;
    private boolean deleted = false;
    Siteinfo siteinfo;
    Page page;
    boolean pageSent;
    Contributor contrib;
    Revision rev;
    int nskey;
    boolean abortFlag;
    boolean errorState = false;
    protected Map<String, String> startElements = new HashMap<String, String>(64);
    protected Map<String, String> endElements = new HashMap<String, String>(64);
    protected Map<String, String> forbiddenIdStartElements = new HashMap<String, String>(64);
    protected Map<String, String> forbiddenIdEndElements = new HashMap<String, String>(64);
    private static final TimeZone utc = TimeZone.getTimeZone("UTC");

    protected void setupForbiddenStartElements() {
        this.forbiddenIdStartElements.put(REVISION, REVISION);
        this.forbiddenIdStartElements.put(CONTRIBUTOR, CONTRIBUTOR);
    }

    protected void setupForbiddenEndElements() {
        this.forbiddenIdEndElements.put(THREAD_SUBJECT, THREAD_SUBJECT);
        this.forbiddenIdEndElements.put(THREAD_PARENT, THREAD_PARENT);
        this.forbiddenIdEndElements.put(THREAD_ANCESTOR, THREAD_ANCESTOR);
        this.forbiddenIdEndElements.put(THREAD_PAGE, THREAD_PAGE);
        this.forbiddenIdEndElements.put(THREAD_ID, THREAD_ID);
        this.forbiddenIdEndElements.put(THREAD_SUMMARY_PAGE, THREAD_SUMMARY_PAGE);
        this.forbiddenIdEndElements.put(THREAD_AUTHOR, THREAD_AUTHOR);
        this.forbiddenIdEndElements.put(THREAD_EDIT_STATUS, THREAD_EDIT_STATUS);
        this.forbiddenIdEndElements.put(THREAD_TYPE, THREAD_TYPE);
        this.forbiddenIdEndElements.put(COMMENT, COMMENT);
        this.forbiddenIdEndElements.put(CONTRIBUTOR, CONTRIBUTOR);
        this.forbiddenIdEndElements.put(ID, ID);
        this.forbiddenIdEndElements.put(IP, IP);
        this.forbiddenIdEndElements.put(MINOR, MINOR);
        this.forbiddenIdEndElements.put(PAGE, PAGE);
        this.forbiddenIdEndElements.put(RESTRICTIONS, RESTRICTIONS);
        this.forbiddenIdEndElements.put(REVISION, REVISION);
        this.forbiddenIdEndElements.put(TEXT, TEXT);
        this.forbiddenIdEndElements.put(TIMESTAMP, TIMESTAMP);
        this.forbiddenIdEndElements.put(TITLE, TITLE);
        this.forbiddenIdEndElements.put(USERNAME, USERNAME);
    }

    protected abstract void setupStartElements();

    protected abstract void setupEndElements();

    public AbstractXmlDumpReader(InputStream inputStream, DumpWriter writer) {
        this.input = inputStream;
        this.writer = writer;
        this.buffer = new char[4096];
        this.len = 0;
        this.hasContent = false;
        this.setupStartElements();
        this.setupEndElements();
        this.setupForbiddenStartElements();
        this.setupForbiddenEndElements();
    }

    public void readDump() throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.input, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        this.writer.close();
    }

    public void abort() {
        this.abortFlag = true;
    }

    private boolean notAllowedStart(String startTag) {
        this.errorState = this.errorState && this.startElements.containsKey(startTag) && this.forbiddenIdStartElements.containsKey(startTag);
        return this.errorState;
    }

    private boolean notAllowedEnd(String endTag) {
        this.errorState = this.errorState && this.endElements.containsKey(endTag) && this.forbiddenIdEndElements.containsKey(endTag);
        return this.errorState;
    }

    @Override
    public void startElement(String uri, String localname, String qName, Attributes attributes) throws SAXException {
        this.len = 0;
        this.hasContent = false;
        if (this.abortFlag) {
            throw new SAXException("XmlDumpReader set abort flag.");
        }
        String d = attributes.getValue("deleted");
        this.deleted = d != null && d.equals("deleted");
        try {
            qName = this.startElements.get(qName);
            if (qName == null || this.notAllowedStart(qName)) {
                return;
            }
            if (qName == REVISION) {
                this.openRevision();
            } else if (qName == CONTRIBUTOR) {
                this.openContributor();
            } else if (qName == PAGE) {
                this.openPage();
            } else if (qName == MEDIAWIKI) {
                this.openMediaWiki();
            } else if (qName == SITEINFO) {
                this.openSiteinfo();
            } else if (qName == NAMESPACES) {
                this.openNamespaces();
            } else if (qName == NAMESPACE) {
                this.openNamespace(attributes);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.buffer.length < this.len + length) {
            int maxlen = this.buffer.length * 2;
            if (maxlen < this.len + length) {
                maxlen = this.len + length;
            }
            char[] tmp = new char[maxlen];
            System.arraycopy(this.buffer, 0, tmp, 0, this.len);
            this.buffer = tmp;
        }
        System.arraycopy(ch, start, this.buffer, this.len, length);
        this.len += length;
        this.hasContent = true;
    }

    @Override
    public void endElement(String uri, String localname, String qName) throws SAXException {
        try {
            qName = this.endElements.get(qName);
            if (qName == null || this.notAllowedEnd(qName)) {
                return;
            }
            if (qName == ID) {
                this.readId();
            } else if (qName == REVISION) {
                this.closeRevision();
            } else if (qName == TIMESTAMP) {
                this.readTimestamp();
            } else if (qName == TEXT) {
                this.readText();
            } else if (qName == CONTRIBUTOR) {
                this.closeContributor();
            } else if (qName == USERNAME) {
                this.readUsername();
            } else if (qName == IP) {
                this.readIp();
            } else if (qName == COMMENT) {
                this.readComment();
            } else if (qName == MINOR) {
                this.readMinor();
            } else if (qName == PAGE) {
                this.closePage();
            } else if (qName == TITLE) {
                this.readTitle();
            } else if (qName == RESTRICTIONS) {
                this.readRestrictions();
            } else if (qName.startsWith("Thread")) {
                this.threadAttribute(qName);
            } else if (qName == MEDIAWIKI) {
                this.closeMediaWiki();
            } else if (qName == SITEINFO) {
                this.closeSiteinfo();
            } else if (qName == SITENAME) {
                this.readSitename();
            } else if (qName == BASE) {
                this.readBase();
            } else if (qName == GENERATOR) {
                this.readGenerator();
            } else if (qName == CASE) {
                this.readCase();
            } else if (qName == NAMESPACES) {
                this.closeNamespaces();
            } else if (qName == NAMESPACE) {
                this.closeNamespace();
            }
        }
        catch (IOException e) {
            throw (SAXException)new SAXException(e.getMessage()).initCause(e);
        }
    }

    void threadAttribute(String attrib) throws IOException {
        if (attrib.equals(THREAD_PAGE)) {
            this.page.DiscussionThreadingInfo.put(attrib, new Title(this.bufferContents(), this.siteinfo.Namespaces));
        } else {
            this.page.DiscussionThreadingInfo.put(attrib, this.bufferContents());
        }
    }

    void openMediaWiki() throws IOException {
        this.siteinfo = null;
        this.writer.writeStartWiki();
    }

    void closeMediaWiki() throws IOException {
        this.writer.writeEndWiki();
        this.siteinfo = null;
    }

    void openSiteinfo() {
        this.siteinfo = new Siteinfo();
    }

    void closeSiteinfo() throws IOException {
        this.writer.writeSiteinfo(this.siteinfo);
    }

    private String bufferContentsOrNull() {
        if (!this.hasContent) {
            return null;
        }
        return this.bufferContents();
    }

    private String bufferContents() {
        if (this.len == 0) {
            return "";
        }
        String result = new String(this.buffer, 0, this.len);
        result = result.replace("\\", "\\\\");
        return result;
    }

    void readSitename() {
        this.siteinfo.Sitename = this.bufferContents();
    }

    void readBase() {
        this.siteinfo.Base = this.bufferContents();
    }

    void readGenerator() {
        this.siteinfo.Generator = this.bufferContents();
    }

    void readCase() {
        this.siteinfo.Case = this.bufferContents();
    }

    void openNamespaces() {
        this.siteinfo.Namespaces = new NamespaceSet();
    }

    void openNamespace(Attributes attribs) {
        this.nskey = Integer.parseInt(attribs.getValue("key"));
    }

    void closeNamespace() {
        this.siteinfo.Namespaces.add(this.nskey, this.bufferContents());
    }

    void closeNamespaces() {
    }

    void openPage() {
        this.page = new Page();
        this.pageSent = false;
    }

    void closePage() throws IOException {
        if (this.pageSent) {
            this.writer.writeEndPage();
        }
        this.page = null;
    }

    void readTitle() {
        this.page.Title = new Title(this.bufferContents(), this.siteinfo.Namespaces);
    }

    void readId() {
        int id = Integer.parseInt(this.bufferContents());
        if (this.contrib != null) {
            this.contrib.Id = id;
        } else if (this.rev != null) {
            this.rev.Id = id;
        } else if (this.page != null) {
            this.page.Id = id;
        } else {
            Logger.getLogger((String)AbstractXmlDumpReader.class.getName()).debug((Object)"Unexpected <id> outside a <page>, <revision>, or <contributor>");
            this.errorState = true;
            this.contrib = null;
            this.rev = null;
            this.page = null;
        }
    }

    void readRestrictions() {
        this.page.Restrictions = this.bufferContents();
    }

    void openRevision() throws IOException {
        if (!this.pageSent) {
            this.writer.writeStartPage(this.page);
            this.pageSent = true;
        }
        this.rev = new Revision();
    }

    void closeRevision() throws IOException {
        this.writer.writeRevision(this.rev);
        this.rev = null;
    }

    void readTimestamp() {
        this.rev.Timestamp = AbstractXmlDumpReader.parseUTCTimestamp(this.bufferContents());
    }

    void readComment() {
        this.rev.Comment = this.bufferContentsOrNull();
        if (this.rev.Comment == null && !this.deleted) {
            this.rev.Comment = "";
        }
    }

    void readMinor() {
        this.rev.Minor = true;
    }

    void readText() {
        this.rev.Text = this.bufferContentsOrNull();
        if (this.rev.Text == null && !this.deleted) {
            this.rev.Text = "";
        }
    }

    void openContributor() {
        this.contrib = new Contributor();
    }

    void closeContributor() {
        this.rev.Contributor = this.contrib;
        this.contrib = null;
    }

    void readUsername() {
        this.contrib.Username = this.bufferContentsOrNull();
    }

    void readIp() {
        this.contrib.Username = this.bufferContents();
        this.contrib.isIP = true;
    }

    private static Calendar parseUTCTimestamp(String text) {
        String trimmed = text.trim();
        GregorianCalendar ts = new GregorianCalendar(utc);
        ts.set(Integer.parseInt(trimmed.substring(0, 4)), Integer.parseInt(trimmed.substring(5, 7)) - 1, Integer.parseInt(trimmed.substring(8, 10)), Integer.parseInt(trimmed.substring(11, 13)), Integer.parseInt(trimmed.substring(14, 16)), Integer.parseInt(trimmed.substring(17, 19)));
        return ts;
    }
}

