/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.dump.version;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.ILogger;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.Files;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.MetaData;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.version.IDumpVersion;
import de.tudarmstadt.ukp.wikipedia.wikimachine.util.TxtFileWriter;
import java.io.IOException;

public abstract class AbstractDumpVersion
implements IDumpVersion {
    protected static final int NS_MAIN = 0;
    protected static final int NS_TALK = 1;
    protected static final int NS_USER = 2;
    protected static final int NS_USER_TALK = 3;
    protected static final int NS_WIKIPEDIA = 4;
    protected static final int NS_WIKIPEDIA_TALK = 5;
    protected static final int NS_FILE = 6;
    protected static final int NS_FILE_TALK = 7;
    protected static final int NS_MEDIAWIKI = 8;
    protected static final int NS_MEDIAWIKI_TALK = 9;
    protected static final int NS_TEMPLATE = 10;
    protected static final int NS_TEMPLATE_TALK = 11;
    protected static final int NS_HELP = 12;
    protected static final int NS_HELP_TALK = 13;
    protected static final int NS_CATEGORY = 14;
    protected static final int NS_CATEGORY_TALK = 15;
    protected static final int NS_THREAD = 90;
    protected static final int NS_THREAD_TALK = 91;
    protected static final int NS_SUMMARY = 92;
    protected static final int NS_SUMMARY_TALK = 93;
    protected static final int NS_PORTAL = 100;
    protected static final int NS_PORTAL_TALK = 101;
    protected static final int NS_BOOK = 108;
    protected static final int NS_BOOK_TALK = 109;
    protected int timestamp;
    protected MetaData metaData;
    protected TxtFileWriter txtFW;
    protected TxtFileWriter pageCategories;
    protected TxtFileWriter categoryPages;
    protected TxtFileWriter categoryInlinks;
    protected TxtFileWriter categoryOutlinks;
    protected TxtFileWriter pageInlinks;
    protected TxtFileWriter pageOutlinks;
    protected TxtFileWriter page = null;
    protected TxtFileWriter pageMapLine = null;
    protected TxtFileWriter pageRedirects = null;
    protected Files versionFiles;
    protected ILogger logger = null;
    protected boolean skipCategory = true;
    protected boolean skipPage = true;

    @Override
    public void setCategoryRedirectsSkip(boolean skipCategory) {
        this.skipCategory = skipCategory;
    }

    @Override
    public void setPageRedirectsSkip(boolean skipPage) {
        this.skipPage = skipPage;
    }

    @Override
    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void setFiles(Files versionFiles) {
        this.versionFiles = versionFiles;
    }

    @Override
    public void initPageParsing() throws IOException {
        this.txtFW = new TxtFileWriter(this.versionFiles.getOutputCategory());
    }

    @Override
    public void exportAfterPageParsing() throws IOException {
        this.txtFW.flush();
        this.txtFW.close();
    }

    @Override
    public void initCategoryLinksParsing() throws IOException {
        this.pageCategories = new TxtFileWriter(this.versionFiles.getOutputPageCategories());
        this.categoryPages = new TxtFileWriter(this.versionFiles.getOutputCategoryPages());
        this.categoryInlinks = new TxtFileWriter(this.versionFiles.getOutputCategoryInlinks());
        this.categoryOutlinks = new TxtFileWriter(this.versionFiles.getOutputCategoryOutlinks());
    }

    @Override
    public void exportAfterCategoryLinksParsing() throws IOException {
        this.pageCategories.flush();
        this.pageCategories.close();
        this.categoryPages.flush();
        this.categoryPages.close();
        this.categoryInlinks.flush();
        this.categoryInlinks.close();
        this.categoryOutlinks.flush();
        this.categoryOutlinks.close();
    }

    @Override
    public void initPageLinksParsing() throws IOException {
        this.pageInlinks = new TxtFileWriter(this.versionFiles.getOutputPageInlinks());
        this.pageOutlinks = new TxtFileWriter(this.versionFiles.getOutputPageOutlinks());
    }

    @Override
    public void exportAfterPageLinksParsing() throws IOException {
        this.pageInlinks.flush();
        this.pageInlinks.close();
        this.pageOutlinks.flush();
        this.pageOutlinks.close();
    }

    @Override
    public void initTextParsing() throws IOException {
        this.page = new TxtFileWriter(this.versionFiles.getOutputPage());
        this.pageMapLine = new TxtFileWriter(this.versionFiles.getOutputPageMapLine());
        this.pageRedirects = new TxtFileWriter(this.versionFiles.getOutputPageRedirects());
    }

    @Override
    public void exportAfterTextParsing() throws IOException {
        this.page.flush();
        this.page.close();
        this.pageRedirects.flush();
        this.pageRedirects.close();
        this.pageMapLine.flush();
        this.pageMapLine.close();
    }

    @Override
    public void flushByTextParsing() throws IOException {
        this.page.flush();
        this.pageMapLine.flush();
        this.pageRedirects.flush();
    }

    @Override
    public void exportAfterRevisionParsing() {
    }

    @Override
    public void initRevisionParsion() {
    }

    protected String formatBoolean(boolean b) {
        return b ? new String(new byte[]{1}) : "";
    }
}

