/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.domain;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.ILogger;
import java.io.File;

public class Files {
    protected static final String OUTPUT_CATEGORY = "Category.txt";
    protected static final String OUTPUT_PAGECATEGORIES = "page_categories.txt";
    protected static final String OUTPUT_CATEGORYPAGES = "category_pages.txt";
    protected static final String OUTPUT_CATEGORYINLINKS = "category_inlinks.txt";
    protected static final String OUTPUT_CATEGORYOUTLINKS = "category_outlinks.txt";
    protected static final String OUTPUT_PAGEINLINKS = "page_inlinks.txt";
    protected static final String OUTPUT_PAGEOUTLINKS = "page_outlinks.txt";
    protected static final String OUTPUT_PAGE = "Page.txt";
    protected static final String OUTPUT_PAGEMAPLINE = "PageMapLine.txt";
    protected static final String OUTPUT_PAGEREDIRECTS = "page_redirects.txt";
    protected static final String OUTPUT_METADATA = "MetaData.txt";
    protected static final String OUTPUT_DIRECTORY = "output";
    protected File outputDirectory = new File("output");
    protected ILogger logger;

    public Files(ILogger logger) {
        this.logger = logger;
    }

    public Files(Files files) {
        this.outputDirectory = files.outputDirectory;
    }

    protected boolean checkOutputDirectory() {
        boolean result;
        boolean bl = result = this.outputDirectory.exists() && this.outputDirectory.isDirectory();
        if (!result) {
            result = this.outputDirectory.mkdir();
        }
        if (!result) {
            this.logger.log("can't create the output directory");
        }
        return result;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = new File(outputDirectory);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected String getOutputPath(String fileName) {
        this.outputDirectory.mkdir();
        return this.outputDirectory.getAbsolutePath() + File.separator + fileName;
    }

    public String getOutputCategory() {
        return this.getOutputPath(OUTPUT_CATEGORY);
    }

    public String getOutputPageCategories() {
        return this.getOutputPath(OUTPUT_PAGECATEGORIES);
    }

    public String getOutputCategoryPages() {
        return this.getOutputPath(OUTPUT_CATEGORYPAGES);
    }

    public String getOutputCategoryInlinks() {
        return this.getOutputPath(OUTPUT_CATEGORYINLINKS);
    }

    public String getOutputCategoryOutlinks() {
        return this.getOutputPath(OUTPUT_CATEGORYOUTLINKS);
    }

    public String getOutputPageInlinks() {
        return this.getOutputPath(OUTPUT_PAGEINLINKS);
    }

    public String getOutputPageOutlinks() {
        return this.getOutputPath(OUTPUT_PAGEOUTLINKS);
    }

    public String getOutputPage() {
        return this.getOutputPath(OUTPUT_PAGE);
    }

    public String getOutputPageMapLine() {
        return this.getOutputPath(OUTPUT_PAGEMAPLINE);
    }

    public String getOutputPageRedirects() {
        return this.getOutputPath(OUTPUT_PAGEREDIRECTS);
    }

    public String getOutputMetadata() {
        return this.getOutputPath(OUTPUT_METADATA);
    }

    public boolean checkAll() {
        return this.checkOutputDirectory();
    }
}

