/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.domain;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.ILogger;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.CategorylinksParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.PagelinksParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.version.IDumpVersion;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.PageParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.RevisionParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.TextParser;
import java.io.IOException;

public class DumpVersionProcessor {
    private static ILogger logger;
    private Integer step2Log = 10000;
    private Integer step2GC;
    private Integer step2Flush = this.step2GC = Integer.valueOf(this.step2Log * 10);
    private IDumpVersion[] versions;

    public DumpVersionProcessor(ILogger initialLogger) {
        logger = initialLogger;
    }

    public void setDumpVersions(IDumpVersion[] versions) {
        this.versions = versions;
    }

    public void setStep2Log(Integer step2Log) {
        this.step2Log = step2Log;
    }

    public void setStep2GC(Integer step2GC) {
        this.step2GC = step2GC;
    }

    public void setStep2Flush(Integer step2Flush) {
        this.step2Flush = step2Flush;
    }

    public void processRevision(RevisionParser revisionParser) throws IOException {
        for (IDumpVersion version : this.versions) {
            version.initRevisionParsion();
        }
        int counter = 0;
        while (revisionParser.next()) {
            for (IDumpVersion version : this.versions) {
                version.processRevisionRow(revisionParser);
            }
            this.logAndClear(++counter, "Revision");
        }
        for (IDumpVersion version : this.versions) {
            version.exportAfterRevisionParsing();
            version.freeAfterRevisonParsing();
        }
        revisionParser.close();
    }

    public void processPage(PageParser pageParser) throws IOException {
        for (IDumpVersion version : this.versions) {
            version.initPageParsing();
        }
        int counter = 0;
        while (pageParser.next()) {
            for (IDumpVersion version : this.versions) {
                version.processPageRow(pageParser);
            }
            this.logAndClear(++counter, "Pages");
        }
        for (IDumpVersion version : this.versions) {
            version.exportAfterPageParsing();
            version.freeAfterPageParsing();
        }
        pageParser.close();
    }

    public void processCategorylinks(CategorylinksParser categorylinksParser) throws IOException {
        for (IDumpVersion version : this.versions) {
            version.initCategoryLinksParsing();
        }
        int counter = 0;
        while (categorylinksParser.next()) {
            for (IDumpVersion version : this.versions) {
                version.processCategoryLinksRow(categorylinksParser);
            }
            this.logAndClear(++counter, "Categorylinks");
        }
        for (IDumpVersion version : this.versions) {
            version.exportAfterCategoryLinksParsing();
            version.freeAfterCategoryLinksParsing();
        }
        categorylinksParser.close();
    }

    public void processPagelinks(PagelinksParser pagelinksParser) throws IOException {
        for (IDumpVersion version : this.versions) {
            version.initPageLinksParsing();
        }
        int counter = 0;
        while (pagelinksParser.next()) {
            for (IDumpVersion version : this.versions) {
                version.processPageLinksRow(pagelinksParser);
            }
            this.logAndClear(++counter, "Pagelinks");
        }
        for (IDumpVersion version : this.versions) {
            version.exportAfterPageLinksParsing();
            version.freeAfterPageLinksParsing();
        }
        pagelinksParser.close();
    }

    public void processText(TextParser textParser) throws IOException {
        for (IDumpVersion version : this.versions) {
            version.initTextParsing();
        }
        int counter = 0;
        while (textParser.next()) {
            for (IDumpVersion version : this.versions) {
                version.processTextRow(textParser);
            }
            if (this.step2Flush != 0 && counter % this.step2Flush == 0) {
                for (IDumpVersion version : this.versions) {
                    version.flushByTextParsing();
                }
            }
            this.logAndClear(++counter, "Text");
        }
        for (IDumpVersion version : this.versions) {
            version.exportAfterTextParsing();
            version.freeAfterTextParsing();
        }
        textParser.close();
    }

    public void writeMetaData() throws IOException {
        for (IDumpVersion version : this.versions) {
            version.writeMetaData();
        }
    }

    private void logAndClear(int counter, String event) throws IOException {
        if (this.step2Log != 0 && counter % this.step2Log == 0) {
            String message = event + " " + counter;
            logger.log(message);
        }
        if (this.step2GC != 0 && counter % this.step2GC == 0) {
            System.gc();
        }
    }
}

