/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.domain;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.ILogger;
import java.sql.Timestamp;

public class Configuration {
    private static final Timestamp TIMESTAMP_UNDEFINED = new Timestamp(Long.MIN_VALUE);
    private Timestamp fromTimestamp = TIMESTAMP_UNDEFINED;
    private Timestamp toTimestamp = TIMESTAMP_UNDEFINED;
    private int each;
    private String language;
    private String mainCategory;
    private String disambiguationCategory;
    protected ILogger logger;

    public Configuration(ILogger logger) {
        this.logger = logger;
    }

    public Timestamp getFromTimestamp() {
        return this.fromTimestamp;
    }

    public void setFromTimestamp(Timestamp fromTimestamp) {
        this.fromTimestamp = fromTimestamp;
    }

    public Timestamp getToTimestamp() {
        return this.toTimestamp;
    }

    public void setToTimestamp(Timestamp toTimestamp) {
        this.toTimestamp = toTimestamp;
    }

    public boolean checkTimestamp() {
        boolean result;
        boolean bl = result = !this.toTimestamp.equals(TIMESTAMP_UNDEFINED) && !this.fromTimestamp.equals(TIMESTAMP_UNDEFINED) && (this.toTimestamp.after(this.fromTimestamp) || this.toTimestamp.equals(this.fromTimestamp));
        if (!result) {
            this.logger.log("fromTimestamp is after toTimestamp");
        }
        return result;
    }

    public int getEach() {
        return this.each;
    }

    public void setEach(int each) {
        this.each = each;
    }

    public boolean checkEach() {
        boolean result;
        boolean bl = result = this.each > 0;
        if (!result) {
            this.logger.log("'each' must be positive");
        }
        return result;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMainCategory() {
        return this.mainCategory;
    }

    public void setMainCategory(String mainCategory) {
        this.mainCategory = mainCategory;
    }

    public String getDisambiguationCategory() {
        return this.disambiguationCategory;
    }

    public void setDisambiguationCategory(String disambiguationCategory) {
        this.disambiguationCategory = disambiguationCategory;
    }

    public boolean checkTimeConfig() {
        return this.checkEach() && this.checkTimestamp();
    }
}

