/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.decompression;

import de.tudarmstadt.ukp.wikipedia.wikimachine.decompression.BZip2Decompressor;
import de.tudarmstadt.ukp.wikipedia.wikimachine.decompression.GZipDecompressor;
import de.tudarmstadt.ukp.wikipedia.wikimachine.decompression.IDecompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class UniversalDecompressor
implements IDecompressor {
    public static final String FILEPLACEHOLDER = "%f";
    private static final String PROPERTIES_PATH = "decompressor.xml";
    private HashMap<String, String> externalSupport;
    private HashMap<String, IDecompressor> internalSupport = new HashMap();

    private boolean isExternalSupported(String extension) {
        return this.externalSupport.containsKey(extension);
    }

    private boolean isInternalSupported(String extension) {
        return this.internalSupport.containsKey(extension);
    }

    public UniversalDecompressor() {
        this.internalSupport.put("bz2", new BZip2Decompressor());
        this.internalSupport.put("gz", new GZipDecompressor());
        this.externalSupport = new HashMap();
        this.loadExternal();
    }

    private void loadExternal() {
        Properties properties = new Properties();
        try {
            properties.loadFromXML(new FileInputStream(PROPERTIES_PATH));
            for (String key : properties.stringPropertyNames()) {
                this.externalSupport.put(key, properties.getProperty(key));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public boolean isSupported(String fileName) {
        String extension = this.getExtension(fileName);
        return this.isInternalSupported(extension) || this.isExternalSupported(extension);
    }

    private InputStream startExternal(String fileName) {
        InputStream result = null;
        try {
            String extension = this.getExtension(fileName);
            String command = this.externalSupport.get(extension).replace(FILEPLACEHOLDER, fileName);
            Process externalProcess = Runtime.getRuntime().exec(command);
            result = externalProcess.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private InputStream getDefault(String fileName) {
        FileInputStream result = null;
        try {
            result = new FileInputStream(fileName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public InputStream getInputStream(String fileName) throws IOException {
        InputStream inputStream = null;
        if (this.fileExists(fileName)) {
            String extension = this.getExtension(fileName);
            inputStream = this.isExternalSupported(extension) ? this.startExternal(fileName) : (this.isInternalSupported(extension) ? this.internalSupport.get(extension).getInputStream(fileName) : this.getDefault(fileName));
        }
        return inputStream;
    }

    private boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }
}

