/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.debug;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.AbstractLogger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class MailMemorylLogger
extends AbstractLogger {
    private static final Logger log4j = Logger.getLogger(MailMemorylLogger.class);
    private static final String DATE_FORMAT_NOW = "yyyy.MM.dd HH:mm:ss";
    private static final String ADDRESS_TO = "mail.logger.system@googlemail.com";
    private static final String ADDRESS_FROM = "i_galkin@rbg.informatik.tu-darmstadt.de";
    private static final Properties TRANSPORT_PROPERTIES = new Properties(){
        private static final long serialVersionUID = 1L;
        {
            this.put("mail.transport.protocol", "smtp");
            this.put("mail.smtp.host", "mail.rbg.informatik.tu-darmstadt.de");
            this.put("mail.smtp.port", "25");
            this.put("mail.smtp.from", MailMemorylLogger.ADDRESS_FROM);
            this.put("mail.smtp.localhost", "tk.informatik.tu-darmstadt.de");
        }
    };
    private static final Session MAIL_SESSION = Session.getDefaultInstance((Properties)TRANSPORT_PROPERTIES);
    private static final int MESSAGES_MAX = 1000;
    private static final int LASTSEND_MAX = 10800000;
    private String subject = "[TIMEMACHINE](" + MailMemorylLogger.now() + ")";
    private long lastSend = 0L;
    private StringBuffer messageBuffer = new StringBuffer(10000);
    private int messageCount = 0;

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    protected Message initMessage() throws MessagingException {
        MimeMessage msg = new MimeMessage(MAIL_SESSION);
        msg.setFrom((Address)new InternetAddress(ADDRESS_FROM));
        msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(ADDRESS_TO));
        msg.setSubject(this.subject);
        return msg;
    }

    protected void appendRunntimeInfo() {
        this.messageBuffer.append("local time\t");
        this.messageBuffer.append(new Date());
        this.messageBuffer.append("\ttotal memory\t");
        this.messageBuffer.append(Runtime.getRuntime().totalMemory());
        this.messageBuffer.append("\tfree memory\t");
        this.messageBuffer.append(Runtime.getRuntime().freeMemory());
        this.messageBuffer.append("\t");
    }

    private void send() {
        try {
            Message msg = this.initMessage();
            msg.setContent((Object)this.messageBuffer.toString(), "text/plain");
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            log4j.error((Object)"Unable to send message", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.messageBuffer.length() > 0) {
            this.send();
        }
        super.finalize();
    }

    @Override
    public void logObject(Object message) {
        this.appendRunntimeInfo();
        this.messageBuffer.append(message);
        this.messageBuffer.append("\n");
        long timeStamp = System.currentTimeMillis();
        if (++this.messageCount > 1000 || timeStamp - this.lastSend > 10800000L) {
            this.send();
            this.messageCount = 0;
            this.lastSend = timeStamp;
            this.messageBuffer.setLength(0);
        }
    }
}

