/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.debug;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.AbstractLogger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class FileMemoryLogger
extends AbstractLogger {
    private static final String FILEHEADER = "\"Date/Time\",\"Total Memory\",\"Free Memory\",\"Message\"";
    private static final Logger log4j = Logger.getLogger(FileMemoryLogger.class);
    private static final SimpleDateFormat FILENAME_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final SimpleDateFormat DATEFIELD_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private PrintStream output = null;

    public static String now(SimpleDateFormat format) {
        return format.format(new Date());
    }

    public FileMemoryLogger() {
        try {
            this.output = new PrintStream(new FileOutputStream(FILENAME_FORMAT.format(new Date()).concat(".txt")));
            this.output.println(FILEHEADER);
        }
        catch (FileNotFoundException e) {
            log4j.error((Object)e.getMessage());
            this.output = null;
        }
    }

    @Override
    public void logObject(Object message) {
        if (this.output != null) {
            this.output.println("\"" + DATEFIELD_FORMAT.format(new Date()) + "\",\"" + Runtime.getRuntime().totalMemory() + "\",\"" + Runtime.getRuntime().freeMemory() + "\",\"" + message + "\"");
        }
    }

    protected void finalize() throws Throwable {
        this.output.close();
        super.finalize();
    }
}

