/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.wikimachine.debug;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.ILogger;

public abstract class AbstractLogger
implements ILogger {
    protected boolean isThrowable(Class<?> c) {
        boolean throwable = false;
        if (c != null && !(throwable = c.equals(Throwable.class))) {
            for (Class<?> i : c.getInterfaces()) {
                if (throwable |= this.isThrowable(i)) break;
            }
            if (!throwable) {
                throwable |= this.isThrowable(c.getSuperclass());
            }
        }
        return throwable;
    }

    protected String createThrowableMessage(Throwable e) {
        StringBuffer message = new StringBuffer();
        message.append(e.getMessage());
        message.append('\n');
        for (StackTraceElement currentTrace : e.getStackTrace()) {
            message.append('\n');
            message.append(currentTrace);
        }
        return message.toString();
    }

    @Override
    public void log(Object message) {
        if (this.isThrowable(message.getClass())) {
            this.logObject(this.createThrowableMessage((Throwable)message));
        } else {
            this.logObject(message);
        }
    }

    protected abstract void logObject(Object var1);
}

