/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class XmlWriter {
    OutputStream stream;
    String encoding;
    ArrayList stack;
    BufferedWriter writer;

    public XmlWriter(OutputStream stream) throws IOException {
        this.stream = stream;
        this.encoding = "utf-8";
        this.stack = new ArrayList();
        this.writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF8"));
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public void openXml() throws IOException {
        this.writeRaw("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" ?>\n");
    }

    public void closeXml() {
    }

    public void emptyElement(String element) throws IOException {
        this.emptyElement(element, null);
    }

    public void emptyElement(String element, String[][] attributes) throws IOException {
        this.startElement(element, attributes, "/>\n");
        this.deindent();
    }

    public void openElement(String element) throws IOException {
        this.openElement(element, null);
    }

    public void openElement(String element, String[][] attributes) throws IOException {
        this.startElement(element, attributes, ">\n");
    }

    public void closeElement() throws IOException {
        this.closeElement(true);
    }

    public void closeElement(boolean indent) throws IOException {
        String[] bits = this.deindent();
        String element = bits[0];
        String space = bits[1];
        if (indent) {
            this.writeRaw(space + "</" + element + ">\n");
        } else {
            this.writeRaw("</" + element + ">\n");
        }
    }

    public void textElement(String element, String text) throws IOException {
        this.textElement(element, text, null);
    }

    public void textElement(String element, String text, String[][] attributes) throws IOException {
        if (text == null || text.length() == 0) {
            this.emptyElement(element, attributes);
        } else {
            this.startElement(element, attributes, ">");
            this.writeEscaped(text);
            this.closeElement(false);
        }
    }

    void startElement(String element, String[][] attributes, String terminator) throws IOException {
        this.writeRaw(this.indent(element));
        this.writeRaw('<');
        this.writeRaw(element);
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                this.writeRaw(' ');
                this.writeRaw(attributes[i][0]);
                this.writeRaw("=\"");
                this.writeEscaped(attributes[i][1]);
                this.writeRaw('\"');
            }
        }
        this.writeRaw(terminator);
    }

    void writeRaw(String data) throws IOException {
        this.writer.write(data);
    }

    void writeRaw(char c) throws IOException {
        this.writer.write(c);
    }

    void writeEscaped(String data) throws IOException {
        int end = data.length();
        block6: for (int i = 0; i < end; ++i) {
            char c = data.charAt(i);
            switch (c) {
                case '&': {
                    this.writer.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.writer.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    this.writer.write("&quot;");
                    continue block6;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
    }

    private String indent(String element) {
        int level = this.stack.size();
        this.stack.add(element);
        return this.spaces(level);
    }

    private String[] deindent() {
        String element = (String)this.stack.remove(this.stack.size() - 1);
        String space = this.spaces(this.stack.size());
        return new String[]{element, space};
    }

    private String spaces(int level) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < level * 2; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

