/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Contributor;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Siteinfo;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public class XmlDumpWriter
implements DumpWriter {
    protected OutputStream stream;
    protected XmlWriter writer;
    protected static final String version = "0.3";
    protected static final String ns = "http://www.mediawiki.org/xml/export-0.3/";
    protected static final String schema = "http://www.mediawiki.org/xml/export-0.3.xsd";
    protected static final DateFormat dateFormat = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'");
    static final String[][] deletedAttrib;

    public XmlDumpWriter(OutputStream output) throws IOException {
        this.stream = output;
        this.writer = new XmlWriter(this.stream);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void writeStartWiki() throws IOException {
        this.writer.openXml();
        this.writer.openElement("mediawiki", new String[][]{{"xmlns", ns}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.mediawiki.org/xml/export-0.3/ http://www.mediawiki.org/xml/export-0.3.xsd"}, {"version", version}, {"xml:lang", "en"}});
    }

    @Override
    public void writeEndWiki() throws IOException {
        this.writer.closeElement();
        this.writer.closeXml();
    }

    @Override
    public void writeSiteinfo(Siteinfo info) throws IOException {
        XmlWriter writer = this.writer;
        writer.openElement("siteinfo");
        writer.textElement("sitename", info.Sitename);
        writer.textElement("base", info.Base);
        writer.textElement("generator", info.Generator);
        writer.textElement("case", info.Case);
        writer.openElement("namespaces");
        Iterator i = info.Namespaces.orderedEntries();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            writer.textElement("namespace", e.getValue().toString(), new String[][]{{"key", e.getKey().toString()}});
        }
        writer.closeElement();
        writer.closeElement();
    }

    @Override
    public void writeStartPage(Page page) throws IOException {
        XmlWriter writer = this.writer;
        writer.openElement("page");
        writer.textElement("title", page.Title.toString());
        if (page.Id != 0) {
            writer.textElement("id", Integer.toString(page.Id));
        }
        if (page.Restrictions != null && page.Restrictions.length() != 0) {
            writer.textElement("restrictions", page.Restrictions);
        }
    }

    @Override
    public void writeEndPage() throws IOException {
        this.writer.closeElement();
    }

    @Override
    public void writeRevision(Revision rev) throws IOException {
        String[][] stringArray;
        XmlWriter writer = this.writer;
        writer.openElement("revision");
        if (rev.Id != 0) {
            writer.textElement("id", Integer.toString(rev.Id));
        }
        writer.textElement("timestamp", XmlDumpWriter.formatTimestamp(rev.Timestamp));
        this.writeContributor(rev.Contributor);
        if (rev.Minor) {
            writer.emptyElement("minor");
        }
        if (rev.Comment == null) {
            writer.emptyElement("comment", deletedAttrib);
        } else if (rev.Comment.length() != 0) {
            writer.textElement("comment", rev.Comment);
        }
        String string = rev.Text;
        if (rev.Text == null) {
            String[][] stringArrayArray = new String[2][];
            stringArrayArray[0] = new String[]{"xml:space", "preserve"};
            stringArray = stringArrayArray;
            stringArrayArray[1] = new String[]{"deleted", "deleted"};
        } else {
            String[][] stringArray2 = new String[1][];
            stringArray = stringArray2;
            stringArray2[0] = new String[]{"xml:space", "preserve"};
        }
        writer.textElement("text", string, stringArray);
        writer.closeElement();
    }

    static String formatTimestamp(Calendar ts) {
        return dateFormat.format(ts.getTime());
    }

    void writeContributor(Contributor contrib) throws IOException {
        XmlWriter writer = this.writer;
        if (contrib.Username == null) {
            writer.emptyElement("contributor", deletedAttrib);
        } else {
            writer.openElement("contributor");
            if (contrib.isIP) {
                writer.textElement("ip", contrib.Username);
            } else {
                writer.textElement("username", contrib.Username);
                writer.textElement("id", Integer.toString(contrib.Id));
            }
            writer.closeElement();
        }
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        deletedAttrib = new String[][]{{"deleted", "deleted"}};
    }
}

