/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Contributor;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.NamespaceSet;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Siteinfo;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Title;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDumpReader
extends DefaultHandler {
    InputStream input;
    DumpWriter writer;
    private char[] buffer;
    private int len;
    private boolean hasContent = false;
    private boolean deleted = false;
    Siteinfo siteinfo;
    Page page;
    boolean pageSent;
    Contributor contrib;
    Revision rev;
    int nskey;
    boolean abortFlag;
    private static final Map startElements = new HashMap(64);
    private static final Map endElements = new HashMap(64);
    private static final TimeZone utc;

    public XmlDumpReader(InputStream inputStream, DumpWriter writer) {
        this.input = inputStream;
        this.writer = writer;
        this.buffer = new char[4096];
        this.len = 0;
        this.hasContent = false;
    }

    public void readDump() throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.input, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        this.writer.close();
    }

    public void abort() {
        this.abortFlag = true;
    }

    @Override
    public void startElement(String uri, String localname, String qName, Attributes attributes) throws SAXException {
        this.len = 0;
        this.hasContent = false;
        if (this.abortFlag) {
            throw new SAXException("XmlDumpReader set abort flag.");
        }
        String d = attributes.getValue("deleted");
        this.deleted = d != null && d.equals("deleted");
        try {
            qName = (String)startElements.get(qName);
            if (qName == null) {
                return;
            }
            if (qName == "revision") {
                this.openRevision();
            } else if (qName == "contributor") {
                this.openContributor();
            } else if (qName == "page") {
                this.openPage();
            } else if (qName == "mediawiki") {
                this.openMediaWiki();
            } else if (qName == "siteinfo") {
                this.openSiteinfo();
            } else if (qName == "namespaces") {
                this.openNamespaces();
            } else if (qName == "namespace") {
                this.openNamespace(attributes);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.buffer.length < this.len + length) {
            int maxlen = this.buffer.length * 2;
            if (maxlen < this.len + length) {
                maxlen = this.len + length;
            }
            char[] tmp = new char[maxlen];
            System.arraycopy(this.buffer, 0, tmp, 0, this.len);
            this.buffer = tmp;
        }
        System.arraycopy(ch, start, this.buffer, this.len, length);
        this.len += length;
        this.hasContent = true;
    }

    @Override
    public void endElement(String uri, String localname, String qName) throws SAXException {
        try {
            qName = (String)endElements.get(qName);
            if (qName == null) {
                return;
            }
            if (qName == "id") {
                this.readId();
            } else if (qName == "revision") {
                this.closeRevision();
            } else if (qName == "timestamp") {
                this.readTimestamp();
            } else if (qName == "text") {
                this.readText();
            } else if (qName == "contributor") {
                this.closeContributor();
            } else if (qName == "username") {
                this.readUsername();
            } else if (qName == "ip") {
                this.readIp();
            } else if (qName == "comment") {
                this.readComment();
            } else if (qName == "minor") {
                this.readMinor();
            } else if (qName == "page") {
                this.closePage();
            } else if (qName == "title") {
                this.readTitle();
            } else if (qName == "restrictions") {
                this.readRestrictions();
            } else if (qName.startsWith("Thread")) {
                this.threadAttribute(qName);
            } else if (qName == "mediawiki") {
                this.closeMediaWiki();
            } else if (qName == "siteinfo") {
                this.closeSiteinfo();
            } else if (qName == "sitename") {
                this.readSitename();
            } else if (qName == "base") {
                this.readBase();
            } else if (qName == "generator") {
                this.readGenerator();
            } else if (qName == "case") {
                this.readCase();
            } else if (qName == "namespaces") {
                this.closeNamespaces();
            } else if (qName == "namespace") {
                this.closeNamespace();
            }
        }
        catch (IOException e) {
            throw (SAXException)new SAXException(e.getMessage()).initCause(e);
        }
    }

    void threadAttribute(String attrib) throws IOException {
        if (attrib.equals("ThreadPage")) {
            this.page.DiscussionThreadingInfo.put(attrib, new Title(this.bufferContents(), this.siteinfo.Namespaces));
        } else {
            this.page.DiscussionThreadingInfo.put(attrib, this.bufferContents());
        }
    }

    void openMediaWiki() throws IOException {
        this.siteinfo = null;
        this.writer.writeStartWiki();
    }

    void closeMediaWiki() throws IOException {
        this.writer.writeEndWiki();
        this.siteinfo = null;
    }

    void openSiteinfo() {
        this.siteinfo = new Siteinfo();
    }

    void closeSiteinfo() throws IOException {
        this.writer.writeSiteinfo(this.siteinfo);
    }

    private String bufferContentsOrNull() {
        if (!this.hasContent) {
            return null;
        }
        return this.bufferContents();
    }

    private String bufferContents() {
        return this.len == 0 ? "" : new String(this.buffer, 0, this.len);
    }

    void readSitename() {
        this.siteinfo.Sitename = this.bufferContents();
    }

    void readBase() {
        this.siteinfo.Base = this.bufferContents();
    }

    void readGenerator() {
        this.siteinfo.Generator = this.bufferContents();
    }

    void readCase() {
        this.siteinfo.Case = this.bufferContents();
    }

    void openNamespaces() {
        this.siteinfo.Namespaces = new NamespaceSet();
    }

    void openNamespace(Attributes attribs) {
        this.nskey = Integer.parseInt(attribs.getValue("key"));
    }

    void closeNamespace() {
        this.siteinfo.Namespaces.add(this.nskey, this.bufferContents());
    }

    void closeNamespaces() {
    }

    void openPage() {
        this.page = new Page();
        this.pageSent = false;
    }

    void closePage() throws IOException {
        if (this.pageSent) {
            this.writer.writeEndPage();
        }
        this.page = null;
    }

    void readTitle() {
        this.page.Title = new Title(this.bufferContents(), this.siteinfo.Namespaces);
    }

    void readId() {
        int id = Integer.parseInt(this.bufferContents());
        if (this.contrib != null) {
            this.contrib.Id = id;
        } else if (this.rev != null) {
            this.rev.Id = id;
        } else if (this.page != null) {
            this.page.Id = id;
        } else {
            throw new IllegalArgumentException("Unexpected <id> outside a <page>, <revision>, or <contributor>");
        }
    }

    void readRestrictions() {
        this.page.Restrictions = this.bufferContents();
    }

    void openRevision() throws IOException {
        if (!this.pageSent) {
            this.writer.writeStartPage(this.page);
            this.pageSent = true;
        }
        this.rev = new Revision();
    }

    void closeRevision() throws IOException {
        this.writer.writeRevision(this.rev);
        this.rev = null;
    }

    void readTimestamp() {
        this.rev.Timestamp = XmlDumpReader.parseUTCTimestamp(this.bufferContents());
    }

    void readComment() {
        this.rev.Comment = this.bufferContentsOrNull();
        if (this.rev.Comment == null && !this.deleted) {
            this.rev.Comment = "";
        }
    }

    void readMinor() {
        this.rev.Minor = true;
    }

    void readText() {
        this.rev.Text = this.bufferContentsOrNull();
        if (this.rev.Text == null && !this.deleted) {
            this.rev.Text = "";
        }
    }

    void openContributor() {
        this.contrib = new Contributor();
    }

    void closeContributor() {
        this.rev.Contributor = this.contrib;
        this.contrib = null;
    }

    void readUsername() {
        this.contrib.Username = this.bufferContentsOrNull();
    }

    void readIp() {
        this.contrib.Username = this.bufferContents();
        this.contrib.isIP = true;
    }

    private static Calendar parseUTCTimestamp(String text) {
        String trimmed = text.trim();
        GregorianCalendar ts = new GregorianCalendar(utc);
        ts.set(Integer.parseInt(trimmed.substring(0, 4)), Integer.parseInt(trimmed.substring(5, 7)) - 1, Integer.parseInt(trimmed.substring(8, 10)), Integer.parseInt(trimmed.substring(11, 13)), Integer.parseInt(trimmed.substring(14, 16)), Integer.parseInt(trimmed.substring(17, 19)));
        return ts;
    }

    static {
        startElements.put("revision", "revision");
        startElements.put("contributor", "contributor");
        startElements.put("page", "page");
        startElements.put("mediawiki", "mediawiki");
        startElements.put("siteinfo", "siteinfo");
        startElements.put("namespaces", "namespaces");
        startElements.put("namespace", "namespace");
        endElements.put("ThreadSubject", "ThreadSubject");
        endElements.put("ThreadParent", "ThreadParent");
        endElements.put("ThreadAncestor", "ThreadAncestor");
        endElements.put("ThreadPage", "ThreadPage");
        endElements.put("ThreadID", "ThreadID");
        endElements.put("ThreadSummaryPage", "ThreadSummaryPage");
        endElements.put("ThreadAuthor", "ThreadAuthor");
        endElements.put("ThreadEditStatus", "ThreadEditStatus");
        endElements.put("ThreadType", "ThreadType");
        endElements.put("base", "base");
        endElements.put("case", "case");
        endElements.put("comment", "comment");
        endElements.put("contributor", "contributor");
        endElements.put("generator", "generator");
        endElements.put("id", "id");
        endElements.put("ip", "ip");
        endElements.put("mediawiki", "mediawiki");
        endElements.put("minor", "minor");
        endElements.put("namespaces", "namespaces");
        endElements.put("namespace", "namespace");
        endElements.put("page", "page");
        endElements.put("restrictions", "restrictions");
        endElements.put("revision", "revision");
        endElements.put("siteinfo", "siteinfo");
        endElements.put("sitename", "sitename");
        endElements.put("text", "text");
        endElements.put("timestamp", "timestamp");
        endElements.put("title", "title");
        endElements.put("username", "username");
        utc = TimeZone.getTimeZone("UTC");
    }
}

