/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.NamespaceSet;

public class Title {
    public Integer Namespace;
    public String Text;
    private NamespaceSet namespaces;

    public Title(Integer namespaceKey, String text, NamespaceSet namespaces) {
        this.namespaces = namespaces;
        this.Namespace = namespaceKey;
        this.Text = text;
    }

    public Title(String prefixedTitle, NamespaceSet namespaces) {
        String prefix;
        this.namespaces = namespaces;
        int colon = prefixedTitle.indexOf(58);
        if (colon > 0 && namespaces.hasPrefix(prefix = prefixedTitle.substring(0, colon))) {
            this.Namespace = namespaces.getIndex(prefix);
            this.Text = prefixedTitle.substring(colon + 1);
            return;
        }
        this.Namespace = new Integer(0);
        this.Text = prefixedTitle;
    }

    public static String ValidateTitleChars(String text) {
        return text;
    }

    public String toString() {
        String prefix = this.namespaces.getPrefix(this.Namespace);
        if (this.Namespace == 0) {
            return prefix.concat(this.Text);
        }
        return prefix + ':' + this.Text;
    }

    public boolean isSpecial() {
        return this.Namespace < 0;
    }

    public boolean isTalk() {
        return !this.isSpecial() && this.Namespace % 2 == 1;
    }

    public Title talkPage() {
        if (this.isTalk()) {
            return this;
        }
        if (this.isSpecial()) {
            return null;
        }
        return new Title(new Integer(this.Namespace + 1), this.Text, this.namespaces);
    }

    public Title subjectPage() {
        if (this.isTalk()) {
            return new Title(new Integer(this.Namespace - 1), this.Text, this.namespaces);
        }
        return this;
    }

    public int hashCode() {
        return this.Namespace.hashCode() ^ this.Text.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Title) {
            Title ot = (Title)other;
            return this.Namespace.equals(ot.Namespace) && this.Text.equals(ot.Text);
        }
        return false;
    }
}

