/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Siteinfo;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class TimeStampFilter
implements DumpWriter {
    DumpWriter sink;
    protected Calendar filterTimeStamp;
    protected Page currentPage;
    protected boolean pageWritten;

    public TimeStampFilter(DumpWriter sink, String timeStamp) throws ParseException {
        this.sink = sink;
        this.filterTimeStamp = Calendar.getInstance();
        this.filterTimeStamp.setTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").parse(timeStamp));
    }

    @Override
    public void close() throws IOException {
        this.sink.close();
    }

    @Override
    public void writeStartWiki() throws IOException {
        this.sink.writeStartWiki();
    }

    @Override
    public void writeEndWiki() throws IOException {
        this.sink.writeEndWiki();
    }

    @Override
    public void writeSiteinfo(Siteinfo info) throws IOException {
        this.sink.writeSiteinfo(info);
    }

    @Override
    public void writeStartPage(Page page) throws IOException {
        this.currentPage = page;
        this.pageWritten = false;
    }

    @Override
    public void writeEndPage() throws IOException {
        if (this.pageWritten) {
            this.sink.writeEndPage();
        }
    }

    @Override
    public void writeRevision(Revision revision) throws IOException {
        if (!this.pageWritten) {
            this.sink.writeStartPage(this.currentPage);
            this.pageWritten = true;
        }
        this.sink.writeRevision(revision);
    }
}

