/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Buffer;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlStream;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlWriter;
import java.io.IOException;

public class SqlWriter15
extends SqlWriter {
    private Page currentPage;
    private Revision lastRevision;
    static final int DELETED_TEXT = 1;
    static final int DELETED_COMMENT = 2;
    static final int DELETED_USER = 4;
    static final int DELETED_RESTRICTED = 8;

    public SqlWriter15(SqlWriter.Traits tr, SqlStream output) {
        super(tr, output);
    }

    public SqlWriter15(SqlWriter.Traits tr, SqlStream output, String prefix) {
        super(tr, output, prefix);
    }

    @Override
    public void writeEndWiki() throws IOException {
        this.flushInsertBuffers();
        super.writeEndWiki();
    }

    @Override
    public void writeStartPage(Page page) {
        this.currentPage = page;
        this.lastRevision = null;
    }

    @Override
    public void writeEndPage() throws IOException {
        if (this.lastRevision != null) {
            this.updatePage(this.currentPage, this.lastRevision);
        }
        this.currentPage = null;
        this.lastRevision = null;
    }

    @Override
    public void writeRevision(Revision revision) throws IOException {
        this.bufferInsertRow(this.traits.getTextTable(), new Object[][]{{"old_id", new Integer(revision.Id)}, {"old_text", revision.Text == null ? "" : revision.Text}, {"old_flags", "utf-8"}});
        int rev_deleted = 0;
        if (revision.Contributor.Username == null) {
            rev_deleted |= 4;
        }
        if (revision.Comment == null) {
            rev_deleted |= 2;
        }
        if (revision.Text == null) {
            rev_deleted |= 1;
        }
        this.bufferInsertRow("revision", new Object[][]{{"rev_id", new Integer(revision.Id)}, {"rev_page", new Integer(this.currentPage.Id)}, {"rev_text_id", new Integer(revision.Id)}, {"rev_comment", revision.Comment == null ? "" : revision.Comment}, {"rev_user", revision.Contributor.Username == null ? ZERO : new Integer(revision.Contributor.Id)}, {"rev_user_text", revision.Contributor.Username == null ? "" : revision.Contributor.Username}, {"rev_timestamp", this.timestampFormat(revision.Timestamp)}, {"rev_minor_edit", revision.Minor ? ONE : ZERO}, {"rev_deleted", rev_deleted == 0 ? ZERO : new Integer(rev_deleted)}});
        this.lastRevision = revision;
    }

    private static int lengthUtf8(String s) {
        int slen = s.length();
        char[] buf = Buffer.get(slen);
        s.getChars(0, slen, buf, 0);
        int len = 0;
        for (int i = 0; i < slen; ++i) {
            char c = buf[i];
            if (c < '\u0080') {
                ++len;
                continue;
            }
            if (c < '\u0800') {
                len += 2;
                continue;
            }
            if (c < '\ud800' || c >= '\ue000') {
                len += 3;
                continue;
            }
            len += 4;
            ++i;
        }
        return len;
    }

    private void updatePage(Page page, Revision revision) throws IOException {
        this.bufferInsertRow("page", new Object[][]{{"page_id", new Integer(page.Id)}, {"page_namespace", page.Title.Namespace}, {"page_title", SqlWriter15.titleFormat(page.Title.Text)}, {"page_restrictions", page.Restrictions}, {"page_counter", ZERO}, {"page_is_redirect", revision.isRedirect() ? ONE : ZERO}, {"page_is_new", ZERO}, {"page_random", this.traits.getRandom()}, {"page_touched", this.traits.getCurrentTime()}, {"page_latest", new Integer(revision.Id)}, {"page_len", new Integer(SqlWriter15.lengthUtf8(revision.Text))}});
        this.checkpoint();
    }
}

