/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlStream;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlWriter;
import java.io.IOException;

public class SqlWriter14
extends SqlWriter {
    private Page currentPage;
    private Revision lastRevision;

    public SqlWriter14(SqlWriter.Traits tr, SqlStream output) {
        super(tr, output);
    }

    public SqlWriter14(SqlWriter.Traits tr, SqlStream output, String prefix) {
        super(tr, output, prefix);
    }

    @Override
    public void writeStartPage(Page page) {
        this.currentPage = page;
        this.lastRevision = null;
    }

    @Override
    public void writeEndPage() throws IOException {
        if (this.lastRevision != null) {
            this.writeCurRevision(this.currentPage, this.lastRevision);
        }
        this.currentPage = null;
        this.lastRevision = null;
    }

    @Override
    public void writeRevision(Revision revision) throws IOException {
        if (this.lastRevision != null) {
            this.writeOldRevision(this.currentPage, this.lastRevision);
        }
        this.lastRevision = revision;
    }

    private void writeOldRevision(Page page, Revision revision) throws IOException {
        this.bufferInsertRow("old", new Object[][]{{"old_id", new Integer(revision.Id)}, {"old_namespace", page.Title.Namespace}, {"old_title", SqlWriter14.titleFormat(page.Title.Text)}, {"old_text", revision.Text == null ? "" : revision.Text}, {"old_comment", revision.Comment == null ? "" : revision.Comment}, {"old_user", revision.Contributor.Username == null ? ZERO : new Integer(revision.Contributor.Id)}, {"old_user_text", revision.Contributor.Username == null ? "" : revision.Contributor.Username}, {"old_timestamp", this.timestampFormat(revision.Timestamp)}, {"old_minor_edit", revision.Minor ? ONE : ZERO}, {"old_flags", "utf-8"}, {"inverse_timestamp", this.inverseTimestamp(revision.Timestamp)}});
    }

    private void writeCurRevision(Page page, Revision revision) throws IOException {
        this.bufferInsertRow("cur", new Object[][]{{"cur_id", new Integer(page.Id)}, {"cur_namespace", page.Title.Namespace}, {"cur_title", SqlWriter14.titleFormat(page.Title.Text)}, {"cur_text", revision.Text == null ? "" : revision.Text}, {"cur_comment", revision.Comment == null ? "" : revision.Comment}, {"cur_user", revision.Contributor.Username == null ? ZERO : new Integer(revision.Contributor.Id)}, {"cur_user_text", revision.Contributor.Username == null ? "" : revision.Contributor.Username}, {"cur_timestamp", this.timestampFormat(revision.Timestamp)}, {"cur_restrictions", page.Restrictions}, {"cur_counter", ZERO}, {"cur_is_redirect", revision.isRedirect() ? ONE : ZERO}, {"cur_minor_edit", revision.Minor ? ONE : ZERO}, {"cur_random", this.traits.getRandom()}, {"cur_touched", this.traits.getCurrentTime()}, {"inverse_timestamp", this.inverseTimestamp(revision.Timestamp)}});
        this.checkpoint();
    }
}

