/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Siteinfo;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlLiteral;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;

public abstract class SqlWriter
implements DumpWriter {
    private SqlStream stream;
    private String tablePrefix = "";
    protected static final Integer ONE = new Integer(1);
    protected static final Integer ZERO = new Integer(0);
    protected Traits traits;
    private HashMap insertBuffers = new HashMap();
    private static final int blockSize = 524288;
    private static final TimeZone utc = TimeZone.getTimeZone("UTC");
    int commitInterval = 1000;
    int pageCount = 0;

    public SqlWriter(Traits tr, SqlStream output) {
        this.stream = output;
        this.traits = tr;
    }

    public SqlWriter(Traits tr, SqlStream output, String prefix) {
        this.stream = output;
        this.tablePrefix = prefix;
        this.traits = tr;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void writeStartWiki() throws IOException {
        this.stream.writeComment("-- MediaWiki XML dump converted to SQL by mwdumper");
        this.stream.writeStatement("BEGIN");
        String prologue = this.traits.getWikiPrologue();
        if (prologue != null) {
            this.stream.writeStatement(prologue);
        }
    }

    @Override
    public void writeEndWiki() throws IOException {
        this.flushInsertBuffers();
        String epilogue = this.traits.getWikiEpilogue();
        if (epilogue != null) {
            this.stream.writeStatement(epilogue);
        }
        this.stream.writeStatement("COMMIT");
        this.stream.writeComment("-- DONE");
    }

    @Override
    public void writeSiteinfo(Siteinfo info) throws IOException {
        this.stream.writeComment("");
        this.stream.writeComment("-- Site: " + this.commentSafe(info.Sitename));
        this.stream.writeComment("-- URL: " + this.commentSafe(info.Base));
        this.stream.writeComment("-- Generator: " + this.commentSafe(info.Generator));
        this.stream.writeComment("-- Case: " + this.commentSafe(info.Case));
        this.stream.writeComment("--");
        this.stream.writeComment("-- Namespaces:");
        Iterator i = info.Namespaces.orderedEntries();
        while (i.hasNext()) {
            Map.Entry e = (Map.Entry)i.next();
            this.stream.writeComment("-- " + e.getKey() + ": " + e.getValue());
        }
        this.stream.writeComment("");
    }

    @Override
    public abstract void writeStartPage(Page var1) throws IOException;

    @Override
    public abstract void writeEndPage() throws IOException;

    @Override
    public abstract void writeRevision(Revision var1) throws IOException;

    protected String commentSafe(String text) {
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bufferInsertRow(String table, Object[][] row) throws IOException {
        StringBuffer sql = (StringBuffer)this.insertBuffers.get(table);
        if (sql != null) {
            if (this.traits.supportsMultiRowInsert() && sql.length() < 524288) {
                sql.append(',');
                SqlWriter.appendInsertValues(sql, row);
                return;
            }
            this.flushInsertBuffer(table);
        }
        StringBuffer stringBuffer = sql = new StringBuffer(524288);
        synchronized (stringBuffer) {
            this.appendInsertStatement(sql, table, row);
            this.insertBuffers.put(table, sql);
        }
    }

    protected void flushInsertBuffer(String table) throws IOException {
        this.stream.writeStatement((CharSequence)this.insertBuffers.get(table));
        this.insertBuffers.remove(table);
    }

    protected void flushInsertBuffers() throws IOException {
        Iterator iter = this.insertBuffers.values().iterator();
        while (iter.hasNext()) {
            this.stream.writeStatement((CharSequence)iter.next());
        }
        this.insertBuffers.clear();
    }

    protected void insertRow(String table, Object[][] row) throws IOException {
        StringBuffer sql = new StringBuffer(65536);
        this.appendInsertStatement(sql, table, row);
        this.stream.writeStatement(sql);
    }

    private void appendInsertStatement(StringBuffer sql, String table, Object[][] row) {
        sql.append("INSERT INTO ");
        sql.append(this.tablePrefix);
        sql.append(table);
        sql.append(" (");
        for (int i = 0; i < row.length; ++i) {
            String field = (String)row[i][0];
            if (i > 0) {
                sql.append(',');
            }
            sql.append(field);
        }
        sql.append(") VALUES ");
        SqlWriter.appendInsertValues(sql, row);
    }

    private static void appendInsertValues(StringBuffer sql, Object[][] row) {
        sql.append('(');
        for (int i = 0; i < row.length; ++i) {
            Object val = row[i][1];
            if (i > 0) {
                sql.append(',');
            }
            sql.append(SqlWriter.sqlSafe(val));
        }
        sql.append(')');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRow(String table, Object[][] row, String keyField, Object keyValue) throws IOException {
        StringBuffer sql;
        StringBuffer stringBuffer = sql = new StringBuffer(65536);
        synchronized (stringBuffer) {
            sql.append("UPDATE ");
            sql.append(this.tablePrefix);
            sql.append(table);
            sql.append(" SET ");
            for (int i = 0; i < row.length; ++i) {
                String field = (String)row[i][0];
                Object val = row[i][1];
                if (i > 0) {
                    sql.append(',');
                }
                sql.append(field);
                sql.append('=');
                sql.append(SqlWriter.sqlSafe(val));
            }
            sql.append(" WHERE ");
            sql.append(keyField);
            sql.append('=');
            sql.append(SqlWriter.sqlSafe(keyValue));
            this.stream.writeStatement(sql);
        }
    }

    protected static String sqlSafe(Object val) {
        if (val == null) {
            return "NULL";
        }
        String str = val.toString();
        if (val instanceof String) {
            return SqlWriter.sqlEscape(str);
        }
        if (val instanceof Integer) {
            return str;
        }
        if (val instanceof Double) {
            return str;
        }
        if (val instanceof SqlLiteral) {
            return str;
        }
        throw new IllegalArgumentException("Unknown type in SQL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String sqlEscape(String str) {
        StringBuffer sql;
        if (str.length() == 0) {
            return "''";
        }
        int len = str.length();
        StringBuffer stringBuffer = sql = new StringBuffer(len * 2);
        synchronized (stringBuffer) {
            sql.append('\'');
            block10: for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                switch (c) {
                    case '\u0000': {
                        sql.append('\\').append('0');
                        continue block10;
                    }
                    case '\n': {
                        sql.append('\\').append('n');
                        continue block10;
                    }
                    case '\r': {
                        sql.append('\\').append('r');
                        continue block10;
                    }
                    case '\u001a': {
                        sql.append('\\').append('Z');
                        continue block10;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        sql.append('\\');
                    }
                    default: {
                        sql.append(c);
                    }
                }
            }
            sql.append('\'');
            return sql.toString();
        }
    }

    protected static String titleFormat(String title) {
        return title.replace(' ', '_');
    }

    protected String timestampFormat(Calendar time) {
        return this.traits.getTimestampFormatter().format(new Object[]{new Integer(time.get(1)), new Integer(time.get(2) + 1), new Integer(time.get(5)), new Integer(time.get(11)), new Integer(time.get(12)), new Integer(time.get(13))});
    }

    protected String inverseTimestamp(Calendar time) {
        return this.traits.getTimestampFormatter().format(new Object[]{new Integer(9999 - time.get(1)), new Integer(99 - time.get(2) - 1), new Integer(99 - time.get(5)), new Integer(99 - time.get(11)), new Integer(99 - time.get(12)), new Integer(99 - time.get(13))});
    }

    protected static GregorianCalendar now() {
        return new GregorianCalendar(utc);
    }

    protected void checkpoint() throws IOException {
        ++this.pageCount;
        if (this.pageCount % this.commitInterval == 0) {
            this.flushInsertBuffers();
            this.stream.writeStatement("COMMIT");
            this.stream.writeStatement("BEGIN");
        }
    }

    public static class PostgresTraits
    extends Traits {
        private static final MessageFormat timestampFormatter = new MessageFormat("{0,number,0000}-{1,number,00}-{2,number,00} {3,number,00}:{4,number,00}:{5,number,00}");

        @Override
        public SqlLiteral getCurrentTime() {
            return new SqlLiteral("current_timestamp AT TIME ZONE 'UTC'");
        }

        @Override
        public SqlLiteral getRandom() {
            return new SqlLiteral("RANDOM()");
        }

        @Override
        public boolean supportsMultiRowInsert() {
            return false;
        }

        @Override
        public String getTextTable() {
            return "pagecontent";
        }

        @Override
        public MessageFormat getTimestampFormatter() {
            return timestampFormatter;
        }

        @Override
        public String getWikiPrologue() {
            return "ALTER TABLE revision DISABLE TRIGGER ALL;ALTER TABLE page DISABLE TRIGGER ALL;";
        }

        @Override
        public String getWikiEpilogue() {
            return "ALTER TABLE revision ENABLE TRIGGER ALL;ALTER TABLE page ENABLE TRIGGER ALL;";
        }
    }

    public static class MySQLTraits
    extends Traits {
        private static final MessageFormat timestampFormatter = new MessageFormat("{0,number,0000}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}");

        @Override
        public SqlLiteral getCurrentTime() {
            return new SqlLiteral("DATE_ADD('1970-01-01', INTERVAL UNIX_TIMESTAMP() SECOND)+0");
        }

        @Override
        public SqlLiteral getRandom() {
            return new SqlLiteral("RAND()");
        }

        @Override
        public boolean supportsMultiRowInsert() {
            return true;
        }

        @Override
        public String getTextTable() {
            return "text";
        }

        @Override
        public MessageFormat getTimestampFormatter() {
            return timestampFormatter;
        }
    }

    public static abstract class Traits {
        public abstract SqlLiteral getCurrentTime();

        public abstract SqlLiteral getRandom();

        public abstract String getTextTable();

        public abstract boolean supportsMultiRowInsert();

        public abstract MessageFormat getTimestampFormatter();

        public String getWikiPrologue() {
            return null;
        }

        public String getWikiEpilogue() {
            return null;
        }
    }
}

