/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Siteinfo;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;

public class SphinxWriter
implements DumpWriter {
    protected OutputStream stream;
    protected XmlWriter writer;
    protected Page _page;
    protected Revision _rev;

    public SphinxWriter(OutputStream output) throws IOException {
        this.stream = output;
        this.writer = new XmlWriter(this.stream);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void writeStartWiki() throws IOException {
        this.writer.openXml();
    }

    @Override
    public void writeEndWiki() throws IOException {
        this.writer.closeXml();
    }

    @Override
    public void writeSiteinfo(Siteinfo info) throws IOException {
    }

    @Override
    public void writeStartPage(Page page) throws IOException {
        this._page = page;
    }

    @Override
    public void writeEndPage() throws IOException {
        this.writer.openElement("document");
        this.writer.textElement("id", Integer.toString(this._page.Id));
        this.writer.textElement("group", "0");
        this.writer.textElement("timestamp", SphinxWriter.formatTimestamp(this._rev.Timestamp));
        this.writer.textElement("title", this._page.Title.toString());
        this.writer.textElement("body", this._rev.Text);
        this.writer.closeElement();
        this._rev = null;
        this._page = null;
    }

    @Override
    public void writeRevision(Revision rev) throws IOException {
        this._rev = rev;
    }

    static String formatTimestamp(Calendar ts) {
        return Long.toString(ts.getTimeInMillis() / 1000L);
    }
}

