/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Siteinfo;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeSet;

public class RevisionListFilter
implements DumpWriter {
    DumpWriter sink;
    protected TreeSet revIds;
    protected Page currentPage;
    protected boolean pageWritten;

    public RevisionListFilter(DumpWriter sink, String sourceFileName) throws IOException {
        this.sink = sink;
        this.revIds = new TreeSet();
        BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFileName), "utf-8"));
        String line = input.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                this.revIds.add(new Integer(line));
            }
            line = input.readLine();
        }
        input.close();
    }

    @Override
    public void close() throws IOException {
        this.sink.close();
    }

    @Override
    public void writeStartWiki() throws IOException {
        this.sink.writeStartWiki();
    }

    @Override
    public void writeEndWiki() throws IOException {
        this.sink.writeEndWiki();
    }

    @Override
    public void writeSiteinfo(Siteinfo info) throws IOException {
        this.sink.writeSiteinfo(info);
    }

    @Override
    public void writeStartPage(Page page) throws IOException {
        this.currentPage = page;
        this.pageWritten = false;
    }

    @Override
    public void writeEndPage() throws IOException {
        if (this.pageWritten) {
            this.sink.writeEndPage();
        }
    }

    @Override
    public void writeRevision(Revision revision) throws IOException {
        if (this.revIds.contains(new Integer(revision.Id))) {
            if (!this.pageWritten) {
                this.sink.writeStartPage(this.currentPage);
                this.pageWritten = true;
            }
            this.sink.writeRevision(revision);
        }
    }
}

