/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.importer;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.PageFilter;
import java.util.HashMap;

public class NamespaceFilter
extends PageFilter {
    boolean invert;
    HashMap matches;

    public NamespaceFilter(DumpWriter sink, String configString) {
        super(sink);
        this.invert = configString.startsWith("!");
        if (this.invert) {
            configString = configString.substring(1);
        }
        this.matches = new HashMap();
        String[] namespaceKeys = new String[]{"NS_MAIN", "NS_TALK", "NS_USER", "NS_USER_TALK", "NS_PROJECT", "NS_PROJECT_TALK", "NS_IMAGE", "NS_IMAGE_TALK", "NS_MEDIAWIKI", "NS_MEDIAWIKI_TALK", "NS_TEMPLATE", "NS_TEMPLATE_TALK", "NS_HELP", "NS_HELP_TALK", "NS_CATEGORY", "NS_CATEGORY_TALK"};
        String[] itemList = configString.trim().split(",");
        for (int i = 0; i < itemList.length; ++i) {
            String keyString = itemList[i];
            String trimmed = keyString.trim();
            try {
                int key = Integer.parseInt(trimmed);
                this.matches.put(new Integer(key), trimmed);
                continue;
            }
            catch (NumberFormatException e) {
                for (int key = 0; key < namespaceKeys.length; ++key) {
                    if (!trimmed.equalsIgnoreCase(namespaceKeys[key])) continue;
                    this.matches.put(new Integer(key), trimmed);
                }
            }
        }
    }

    @Override
    protected boolean pass(Page page) {
        return this.invert ^ this.matches.containsKey(page.Title.Namespace);
    }
}

