/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.dumper;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class Tools {
    static final int IN_BUF_SZ = 0x100000;
    private static final int OUT_BUF_SZ = 0x100000;

    public static InputStream openInputFile(String arg) throws IOException {
        if (arg.equals("-")) {
            return Tools.openStandardInput();
        }
        BufferedInputStream infile = new BufferedInputStream(new FileInputStream(arg), 0x100000);
        if (arg.endsWith(".gz")) {
            return new GZIPInputStream(infile);
        }
        if (arg.endsWith(".bz2")) {
            return Tools.openBZip2Stream(infile);
        }
        return infile;
    }

    static InputStream openStandardInput() throws IOException {
        return new BufferedInputStream(System.in, 0x100000);
    }

    static InputStream openBZip2Stream(InputStream infile) throws IOException {
        int first = infile.read();
        int second = infile.read();
        if (first != 66 || second != 90) {
            throw new IOException("Didn't find BZ file signature in .bz2 file");
        }
        return new CBZip2InputStream(infile);
    }

    static OutputStream openStandardOutput() {
        return new BufferedOutputStream(System.out, 0x100000);
    }

    static OutputStream createBZip2File(String param) throws IOException, FileNotFoundException {
        OutputStream outfile = Tools.createOutputFile(param);
        outfile.write(66);
        outfile.write(90);
        return new CBZip2OutputStream(outfile);
    }

    static OutputStream createOutputFile(String param) throws IOException, FileNotFoundException {
        File file = new File(param);
        file.createNewFile();
        return new BufferedOutputStream(new FileOutputStream(file), 0x100000);
    }
}

