/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.dumper;

import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.PageFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import java.io.IOException;
import java.text.MessageFormat;

public class ProgressFilter
extends PageFilter {
    int pages = 0;
    int revisions = 0;
    int interval = 1000;
    MessageFormat format = new MessageFormat("{0} pages ({1}/sec), {2} revs ({3}/sec)");
    long start = System.currentTimeMillis();

    public ProgressFilter(DumpWriter sink, int interval) {
        super(sink);
        this.interval = interval;
        if (interval <= 0) {
            throw new IllegalArgumentException("Reporting interval must be positive.");
        }
    }

    @Override
    public void writeStartPage(Page page) throws IOException {
        super.writeStartPage(page);
        ++this.pages;
    }

    @Override
    public void writeRevision(Revision rev) throws IOException {
        super.writeRevision(rev);
        ++this.revisions;
        this.reportProgress();
    }

    @Override
    public void writeEndWiki() throws IOException {
        super.writeEndWiki();
        if (this.revisions % this.interval != 0) {
            this.showProgress();
        }
    }

    private void reportProgress() {
        if (this.revisions % this.interval == 0) {
            this.showProgress();
        }
    }

    private void showProgress() {
        long delta = System.currentTimeMillis() - this.start;
        this.sendOutput(this.format.format(new Object[]{new Integer(this.pages), ProgressFilter.rate(delta, this.pages), new Integer(this.revisions), ProgressFilter.rate(delta, this.revisions)}));
    }

    protected void sendOutput(String text) {
        System.err.println(text);
    }

    private static Object rate(long delta, int count) {
        return (double)delta > 0.001 ? new Double(1000.0 * (double)count / (double)delta) : "-";
    }
}

