/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.mwdumper.dumper;

import de.tudarmstadt.ukp.wikipedia.mwdumper.dumper.ProgressFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.dumper.Tools;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.AfterTimeStampFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.BeforeTimeStampFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.ExactListFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.LatestFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.ListFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.MultiWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.NamespaceFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.NotalkFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.RevisionListFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SphinxWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlFileStream;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlServerStream;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlStream;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlWriter14;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.SqlWriter15;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.TitleMatchFilter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.XmlDumpReader;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.XmlDumpWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.ParseException;
import java.util.zip.GZIPOutputStream;

class Dumper {
    Dumper() {
    }

    public static void main(String[] args) throws IOException, ParseException {
        InputStream input = null;
        OutputWrapper output = null;
        DumpWriter sink = null;
        MultiWriter writers = new MultiWriter();
        int progressInterval = 1000;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String[] bits = Dumper.splitArg(arg);
            if (bits != null) {
                String opt = bits[0];
                String val = bits[1];
                String param = bits[2];
                if (opt.equals("output")) {
                    if (output != null) {
                        if (sink == null) {
                            sink = new XmlDumpWriter(output.getFileStream());
                        }
                        writers.add(sink);
                        sink = null;
                    }
                    output = Dumper.openOutputFile(val, param);
                    continue;
                }
                if (opt.equals("format")) {
                    if (output == null) {
                        output = new OutputWrapper(Tools.openStandardOutput());
                    }
                    if (sink != null) {
                        throw new IllegalArgumentException("Only one format per output allowed.");
                    }
                    sink = Dumper.openOutputSink(output, val, param);
                    continue;
                }
                if (opt.equals("filter")) {
                    if (sink == null) {
                        if (output == null) {
                            output = new OutputWrapper(Tools.openStandardOutput());
                        }
                        sink = new XmlDumpWriter(output.getFileStream());
                    }
                    sink = Dumper.addFilter(sink, val, param);
                    continue;
                }
                if (opt.equals("progress")) {
                    progressInterval = Integer.parseInt(val);
                    continue;
                }
                if (opt.equals("quiet")) {
                    progressInterval = 0;
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized option " + opt);
            }
            if (arg.equals("-")) {
                if (input != null) {
                    throw new IllegalArgumentException("Input already set; can't set to stdin");
                }
                input = Tools.openStandardInput();
                continue;
            }
            if (input != null) {
                throw new IllegalArgumentException("Input already set; can't set to " + arg);
            }
            input = Tools.openInputFile(arg);
        }
        if (input == null) {
            input = Tools.openStandardInput();
        }
        if (output == null) {
            output = new OutputWrapper(Tools.openStandardOutput());
        }
        if (sink == null) {
            sink = new XmlDumpWriter(output.getFileStream());
        }
        writers.add(sink);
        DumpWriter outputSink = progressInterval > 0 ? new ProgressFilter(writers, progressInterval) : writers;
        XmlDumpReader reader = new XmlDumpReader(input, outputSink);
        reader.readDump();
    }

    static String[] splitArg(String arg) {
        if (!arg.startsWith("--")) {
            return null;
        }
        String opt = "";
        String val = "";
        String param = "";
        String[] bits = arg.substring(2).split("=", 2);
        opt = bits[0];
        if (bits.length > 1) {
            String[] bits2 = bits[1].split(":", 2);
            val = bits2[0];
            if (bits2.length > 1) {
                param = bits2[1];
            }
        }
        return new String[]{opt, val, param};
    }

    static OutputWrapper openOutputFile(String dest, String param) throws IOException {
        if (dest.equals("stdout")) {
            return new OutputWrapper(Tools.openStandardOutput());
        }
        if (dest.equals("file")) {
            return new OutputWrapper(Tools.createOutputFile(param));
        }
        if (dest.equals("gzip")) {
            return new OutputWrapper(new GZIPOutputStream(Tools.createOutputFile(param)));
        }
        if (dest.equals("bzip2")) {
            return new OutputWrapper(Tools.createBZip2File(param));
        }
        if (dest.equals("mysql")) {
            return Dumper.connectMySql(param);
        }
        if (dest.equals("postgresql")) {
            return Dumper.connectPostgres(param);
        }
        throw new IllegalArgumentException("Destination sink not implemented: " + dest);
    }

    private static OutputWrapper connectMySql(String param) throws IOException {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            Connection conn = DriverManager.getConnection("jdbc:mysql:" + param);
            return new OutputWrapper(conn);
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private static OutputWrapper connectPostgres(String param) throws IOException {
        try {
            Class.forName("org.postgresql.Driver").newInstance();
            Connection conn = DriverManager.getConnection("jdbc:postgresql:" + param);
            return new OutputWrapper(conn);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    static DumpWriter openOutputSink(OutputWrapper output, String format, String param) throws IOException {
        if (format.equals("xml")) {
            return new XmlDumpWriter(output.getFileStream());
        }
        if (format.equals("sphinx")) {
            return new SphinxWriter(output.getFileStream());
        }
        if (format.equals("mysql") || format.equals("pgsql") || format.equals("sql")) {
            SqlWriter ret;
            SqlStream sqlStream = output.getSqlStream();
            SqlWriter.Traits tr = format.equals("pgsql") ? new SqlWriter.PostgresTraits() : new SqlWriter.MySQLTraits();
            if (param.equals("1.4")) {
                ret = new SqlWriter14(tr, sqlStream);
            } else if (param.equals("1.5")) {
                ret = new SqlWriter15(tr, sqlStream);
            } else {
                throw new IllegalArgumentException("SQL version not known: " + param);
            }
            return ret;
        }
        throw new IllegalArgumentException("Output format not known: " + format);
    }

    static DumpWriter addFilter(DumpWriter sink, String filter, String param) throws IOException, ParseException {
        if (filter.equals("latest")) {
            return new LatestFilter(sink);
        }
        if (filter.equals("namespace")) {
            return new NamespaceFilter(sink, param);
        }
        if (filter.equals("notalk")) {
            return new NotalkFilter(sink);
        }
        if (filter.equals("titlematch")) {
            return new TitleMatchFilter(sink, param);
        }
        if (filter.equals("list")) {
            return new ListFilter(sink, param);
        }
        if (filter.equals("exactlist")) {
            return new ExactListFilter(sink, param);
        }
        if (filter.equals("revlist")) {
            return new RevisionListFilter(sink, param);
        }
        if (filter.equals("before")) {
            return new BeforeTimeStampFilter(sink, param);
        }
        if (filter.equals("after")) {
            return new AfterTimeStampFilter(sink, param);
        }
        throw new IllegalArgumentException("Filter unknown: " + filter);
    }

    static class OutputWrapper {
        private OutputStream fileStream = null;
        private Connection sqlConnection = null;

        OutputWrapper(OutputStream aFileStream) {
            this.fileStream = aFileStream;
        }

        OutputWrapper(Connection anSqlConnection) {
            this.sqlConnection = anSqlConnection;
        }

        OutputStream getFileStream() {
            if (this.fileStream != null) {
                return this.fileStream;
            }
            if (this.sqlConnection != null) {
                throw new IllegalArgumentException("Expected file stream, got SQL connection?");
            }
            throw new IllegalArgumentException("Have neither file nor SQL connection. Very confused!");
        }

        SqlStream getSqlStream() throws IOException {
            if (this.fileStream != null) {
                return new SqlFileStream(this.fileStream);
            }
            if (this.sqlConnection != null) {
                return new SqlServerStream(this.sqlConnection);
            }
            throw new IllegalArgumentException("Have neither file nor SQL connection. Very confused!");
        }
    }
}

