/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.datamachine.dump.xml;

import de.tudarmstadt.ukp.wikipedia.datamachine.domain.DataMachineFiles;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.DumpWriter;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Page;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Revision;
import de.tudarmstadt.ukp.wikipedia.mwdumper.importer.Siteinfo;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.SQLEscape;
import de.tudarmstadt.ukp.wikipedia.wikimachine.util.Redirects;
import de.tudarmstadt.ukp.wikipedia.wikimachine.util.UTFDataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class SimpleBinaryDumpWriter
implements DumpWriter {
    private UTFDataOutputStream pageFile;
    private UTFDataOutputStream revisionFile;
    private UTFDataOutputStream textFile;
    private final DataMachineFiles files;
    private Page currentPage;
    private Revision lastRevision;

    protected void createUncompressed() throws IOException {
        this.pageFile = new UTFDataOutputStream((OutputStream)new FileOutputStream(this.files.getGeneratedPage()));
        this.revisionFile = new UTFDataOutputStream((OutputStream)new FileOutputStream(this.files.getGeneratedRevision()));
        this.textFile = new UTFDataOutputStream((OutputStream)new FileOutputStream(this.files.getGeneratedText()));
    }

    protected void createCompressed() throws IOException {
        this.pageFile = new UTFDataOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(this.files.getGeneratedPage())));
        this.revisionFile = new UTFDataOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(this.files.getGeneratedRevision())));
        this.textFile = new UTFDataOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(this.files.getGeneratedText())));
    }

    public SimpleBinaryDumpWriter(DataMachineFiles files) throws IOException {
        this.files = files;
        if (this.files.isCompressGeneratedFiles()) {
            this.createCompressed();
        } else {
            this.createUncompressed();
        }
    }

    public void close() throws IOException {
        this.pageFile.close();
        this.revisionFile.close();
        this.textFile.close();
    }

    public void writeEndPage() throws IOException {
        if (this.lastRevision != null) {
            this.updatePage(this.currentPage, this.lastRevision);
        }
        this.currentPage = null;
        this.lastRevision = null;
    }

    public void writeEndWiki() throws IOException {
        this.pageFile.flush();
        this.revisionFile.flush();
        this.textFile.flush();
    }

    public void writeRevision(Revision revision) throws IOException {
        this.lastRevision = revision;
        this.revisionFile.writeInt(this.currentPage.Id);
        this.revisionFile.writeInt(revision.Id);
        this.textFile.writeInt(revision.Id);
        this.textFile.writeUTFAsArray(SQLEscape.escape((String)revision.Text));
    }

    public void writeSiteinfo(Siteinfo info) throws IOException {
    }

    public void writeStartPage(Page page) throws IOException {
        this.currentPage = page;
        this.lastRevision = null;
    }

    public void writeStartWiki() throws IOException {
    }

    private void updatePage(Page page, Revision revision) throws IOException {
        this.pageFile.writeInt(page.Id);
        this.pageFile.writeInt(page.Title.Namespace.intValue());
        this.pageFile.writeUTFAsArray(SQLEscape.escape((String)SQLEscape.titleFormat((String)page.Title.Text)));
        this.pageFile.writeBoolean(Redirects.isRedirect((String)revision.Text));
    }
}

