/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.datamachine.dump.version;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.ILogger;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.Files;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.MetaData;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.CategorylinksParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.PagelinksParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.version.IDumpVersion;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.PageParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.RevisionParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.TextParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.util.Redirects;
import de.tudarmstadt.ukp.wikipedia.wikimachine.util.TxtFileWriter;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SingleDumpVersionOriginal
implements IDumpVersion {
    private String language;
    private String mainCategory;
    private String disambiguationsCategory;
    private int nrOfDisambiguations = 0;
    private int nrOfPages = 0;
    private int nrOfCategories = 0;
    private int nrOfRedirects = 0;
    private Map<Integer, String> pPageIdNameMap;
    private Map<Integer, String> cPageIdNameMap;
    private Map<String, Integer> pNamePageIdMap;
    private Map<String, Integer> cNamePageIdMap;
    private Map<Integer, String> rPageIdNameMap;
    private Set<Integer> disambiguations;
    private Map<Integer, Integer> textIdPageIdMap;
    private TxtFileWriter txtFW;
    private TxtFileWriter pageCategories;
    private TxtFileWriter categoryPages;
    private TxtFileWriter categoryInlinks;
    private TxtFileWriter categoryOutlinks;
    private TxtFileWriter pageInlinks;
    private TxtFileWriter pageOutlinks;
    private TxtFileWriter page;
    private TxtFileWriter pageMapLine;
    private TxtFileWriter pageRedirects;
    private String outputDir;
    private ILogger logger;
    private boolean skipPage = true;
    private boolean skipCategory = true;

    private String formatBoolean(boolean b) {
        return b ? new String(new byte[]{1}) : "";
    }

    public void exportAfterCategoryLinksParsing() throws IOException {
        this.pageCategories.export();
        this.categoryPages.export();
        this.categoryInlinks.export();
        this.categoryOutlinks.export();
    }

    public void exportAfterPageLinksParsing() throws IOException {
        this.pageInlinks.export();
        this.pageOutlinks.export();
    }

    public void exportAfterPageParsing() throws IOException {
        this.txtFW.export();
        this.nrOfCategories = this.cPageIdNameMap.keySet().size();
        this.nrOfPages = this.pPageIdNameMap.keySet().size() + this.rPageIdNameMap.keySet().size();
    }

    public void exportAfterRevisionParsing() throws IOException {
    }

    public void exportAfterTextParsing() throws IOException {
        this.page.export();
        this.pageRedirects.export();
        this.pageMapLine.export();
    }

    public void flushByTextParsing() throws IOException {
        this.page.flush();
        this.pageRedirects.flush();
        this.pageMapLine.flush();
    }

    public void freeAfterCategoryLinksParsing() {
    }

    public void freeAfterPageLinksParsing() {
    }

    public void freeAfterPageParsing() {
    }

    public void freeAfterRevisonParsing() {
    }

    public void freeAfterTextParsing() {
        this.page.export();
        this.pageRedirects.export();
        this.pageMapLine.export();
    }

    public void initCategoryLinksParsing() throws IOException {
        this.pageCategories = new TxtFileWriter(this.outputDir + File.separator + "page_categories.txt");
        this.categoryPages = new TxtFileWriter(this.outputDir + File.separator + "category_pages.txt");
        this.categoryInlinks = new TxtFileWriter(this.outputDir + File.separator + "category_inlinks.txt");
        this.categoryOutlinks = new TxtFileWriter(this.outputDir + File.separator + "category_outlinks.txt");
    }

    public void initPageLinksParsing() throws IOException {
        this.pageInlinks = new TxtFileWriter(this.outputDir + File.separator + "page_inlinks.txt");
        this.pageOutlinks = new TxtFileWriter(this.outputDir + File.separator + "page_outlinks.txt");
    }

    public void initPageParsing() throws IOException {
        this.txtFW = new TxtFileWriter(this.outputDir + File.separator + "Category.txt");
    }

    public void initRevisionParsion() {
    }

    public void initTextParsing() throws IOException {
        this.page = new TxtFileWriter(this.outputDir + File.separator + "Page.txt");
        this.pageMapLine = new TxtFileWriter(this.outputDir + File.separator + "PageMapLine.txt");
        this.pageRedirects = new TxtFileWriter(this.outputDir + File.separator + "page_redirects.txt");
    }

    public void initialize(Timestamp timestamp) {
        this.pPageIdNameMap = new HashMap<Integer, String>();
        this.cPageIdNameMap = new HashMap<Integer, String>();
        this.pNamePageIdMap = new HashMap<String, Integer>();
        this.cNamePageIdMap = new HashMap<String, Integer>();
        this.rPageIdNameMap = new HashMap<Integer, String>();
        this.disambiguations = new HashSet<Integer>();
        this.textIdPageIdMap = new HashMap<Integer, Integer>();
    }

    public void processCategoryLinksRow(CategorylinksParser clParser) throws IOException {
        int cl_from = clParser.getClFrom();
        String cl_to = clParser.getClTo();
        if (!this.cNamePageIdMap.containsKey(cl_to)) {
            return;
        }
        if (this.pPageIdNameMap.containsKey(cl_from)) {
            this.categoryPages.addRow(new Object[]{this.cNamePageIdMap.get(cl_to), cl_from});
            this.pageCategories.addRow(new Object[]{cl_from, this.cNamePageIdMap.get(cl_to)});
            if (cl_to.equals(this.disambiguationsCategory)) {
                this.disambiguations.add(cl_from);
                ++this.nrOfDisambiguations;
            }
        } else if (this.cPageIdNameMap.containsKey(cl_from)) {
            this.categoryOutlinks.addRow(new Object[]{this.cNamePageIdMap.get(cl_to), cl_from});
            this.categoryInlinks.addRow(new Object[]{cl_from, this.cNamePageIdMap.get(cl_to)});
        }
    }

    public void processPageLinksRow(PagelinksParser plParser) throws IOException {
        int pl_from = plParser.getPlFrom();
        String pl_to = plParser.getPlTo();
        if (this.skipPage && !this.pPageIdNameMap.containsKey(pl_from) || !this.pNamePageIdMap.containsKey(pl_to)) {
            return;
        }
        this.pageOutlinks.addRow(new Object[]{pl_from, this.pNamePageIdMap.get(pl_to)});
        this.pageInlinks.addRow(new Object[]{this.pNamePageIdMap.get(pl_to), pl_from});
    }

    public void processPageRow(PageParser pageParser) throws IOException {
        int page_namespace = pageParser.getPageNamespace();
        if (page_namespace == 14) {
            if (this.skipCategory && pageParser.getPageIsRedirect()) {
                return;
            }
            int page_id = pageParser.getPageId();
            String page_title = pageParser.getPageTitle();
            if (page_title.equals(this.disambiguationsCategory)) {
                this.logger.log((Object)("Disambiguations Category found: " + page_title));
            }
            if (page_title.equals(this.mainCategory)) {
                this.logger.log((Object)("Main Category found: " + page_title));
            }
            this.cPageIdNameMap.put(page_id, page_title);
            this.cNamePageIdMap.put(page_title, page_id);
            this.txtFW.addRow(new Object[]{page_id, page_id, page_title});
            return;
        }
        if (page_namespace == 0) {
            int page_id = pageParser.getPageId();
            String page_title = pageParser.getPageTitle();
            if (pageParser.getPageIsRedirect()) {
                this.rPageIdNameMap.put(page_id, page_title);
            } else {
                this.pPageIdNameMap.put(page_id, page_title);
                this.pNamePageIdMap.put(page_title, page_id);
            }
        }
    }

    public void processRevisionRow(RevisionParser revisionParser) {
        this.textIdPageIdMap.put(revisionParser.getRevTextId(), revisionParser.getRevPage());
    }

    public void processTextRow(TextParser textParser) throws IOException {
        int text_id = textParser.getOldId();
        if (!this.textIdPageIdMap.containsKey(text_id)) {
            return;
        }
        int page_id = this.textIdPageIdMap.get(text_id);
        if (this.pPageIdNameMap.containsKey(page_id)) {
            this.page.addRow(new Object[]{page_id, page_id, this.pPageIdNameMap.get(page_id), textParser.getOldText(), this.formatBoolean(this.disambiguations.contains(page_id))});
            this.pageMapLine.addRow(new Object[]{page_id, this.pPageIdNameMap.get(page_id), page_id, "NULL", "NULL"});
            return;
        }
        if (this.rPageIdNameMap.containsKey(page_id)) {
            String destination = Redirects.getRedirectDestination((String)textParser.getOldText());
            if (!this.pNamePageIdMap.containsKey(destination)) {
                return;
            }
            this.pageRedirects.addRow(new Object[]{this.pNamePageIdMap.get(destination), this.rPageIdNameMap.get(page_id)});
            this.pageMapLine.addRow(new Object[]{page_id, this.rPageIdNameMap.get(page_id), this.pNamePageIdMap.get(destination), "NULL", "NULL"});
            ++this.nrOfRedirects;
        }
    }

    public void setFiles(Files versionFiles) {
        this.outputDir = versionFiles.getOutputDirectory().getAbsolutePath();
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public void setMetaData(MetaData commonMetaData) {
        this.language = commonMetaData.getLanguage();
        this.mainCategory = commonMetaData.getMainCategory();
        this.disambiguationsCategory = commonMetaData.getDisambiguationCategory();
    }

    public void writeMetaData() throws IOException {
        TxtFileWriter metaData = new TxtFileWriter(this.outputDir + File.separator + "MetaData.txt");
        metaData.addRow(new Object[]{"null", this.language, this.disambiguationsCategory, this.mainCategory, this.nrOfPages, this.nrOfRedirects, this.nrOfDisambiguations, this.nrOfCategories});
        metaData.export();
    }

    public void setCategoryRedirectsSkip(boolean skipCategory) {
        this.skipCategory = skipCategory;
    }

    public void setPageRedirectsSkip(boolean skipPage) {
        this.skipPage = skipPage;
    }
}

