/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.datamachine.dump.version;

import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.CategorylinksParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.PagelinksParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.version.AbstractDumpVersion;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.PageParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.RevisionParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.TextParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.hashing.IStringHashCode;
import de.tudarmstadt.ukp.wikipedia.wikimachine.util.Redirects;
import de.tudarmstadt.ukp.wikipedia.wikimachine.util.TxtFileWriter;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class SingleDumpVersionJDKGeneric<KeyType, HashAlgorithm extends IStringHashCode>
extends AbstractDumpVersion {
    private static final String SQL_NULL = "NULL";
    private static final String DISCUSSION_PREFIX = "Discussion:";
    private Map<Integer, String> pPageIdNameMap;
    private TIntHashSet cPageIdNameMap;
    private Map<KeyType, Integer> pNamePageIdMap;
    private Map<KeyType, Integer> cNamePageIdMap;
    private Map<Integer, String> rPageIdNameMap;
    private TIntHashSet disambiguations;
    private TIntIntHashMap textIdPageIdMap;
    IStringHashCode hashAlgorithm;

    public SingleDumpVersionJDKGeneric(Class<HashAlgorithm> hashAlgorithmClass) throws InstantiationException, IllegalAccessException {
        this.hashAlgorithm = (IStringHashCode)hashAlgorithmClass.newInstance();
        Object hashAlgorithmResult = this.hashAlgorithm.hashCode("test");
    }

    public void freeAfterCategoryLinksParsing() {
        this.cPageIdNameMap.clear();
        this.cNamePageIdMap.clear();
        System.gc();
    }

    public void freeAfterPageLinksParsing() {
    }

    public void freeAfterPageParsing() {
        this.metaData.setNrOfCategories(this.cPageIdNameMap.size());
        this.metaData.setNrOfPages(this.pPageIdNameMap.keySet().size() + this.rPageIdNameMap.keySet().size());
        System.out.println("nrOfCategories: " + this.metaData.getNrOfCategories());
        System.out.println("nrOfPage: " + this.metaData.getNrOfPages());
        System.out.println("nrOfRedirects before testing the validity of the destination:" + this.rPageIdNameMap.size());
    }

    public void freeAfterRevisonParsing() {
    }

    public void freeAfterTextParsing() {
        this.pPageIdNameMap.clear();
        this.cPageIdNameMap.clear();
        this.pNamePageIdMap.clear();
        this.cNamePageIdMap.clear();
        this.rPageIdNameMap.clear();
        this.disambiguations.clear();
        this.textIdPageIdMap.clear();
    }

    public void initialize(Timestamp timestamp) {
        this.pPageIdNameMap = new HashMap<Integer, String>();
        this.cPageIdNameMap = new TIntHashSet();
        this.pNamePageIdMap = new HashMap<KeyType, Integer>();
        this.cNamePageIdMap = new HashMap<KeyType, Integer>();
        this.rPageIdNameMap = new HashMap<Integer, String>();
        this.disambiguations = new TIntHashSet();
        this.textIdPageIdMap = new TIntIntHashMap();
    }

    public void processCategoryLinksRow(CategorylinksParser clParser) throws IOException {
        String cl_to = clParser.getClTo();
        if (cl_to != null) {
            Object clToHash = this.hashAlgorithm.hashCode(cl_to);
            Integer cl_toValue = this.cNamePageIdMap.get(clToHash);
            if (cl_toValue != null) {
                int cl_from = clParser.getClFrom();
                if (this.pPageIdNameMap.containsKey(cl_from)) {
                    this.categoryPages.addRow(new Object[]{cl_toValue, cl_from});
                    this.pageCategories.addRow(new Object[]{cl_from, cl_toValue});
                    if (cl_to.equals(this.metaData.getDisambiguationCategory())) {
                        this.disambiguations.add(cl_from);
                        this.metaData.addDisamb();
                    }
                } else if (this.cPageIdNameMap.contains(cl_from)) {
                    this.categoryOutlinks.addRow(new Object[]{cl_toValue, cl_from});
                    this.categoryInlinks.addRow(new Object[]{cl_from, cl_toValue});
                }
            }
        } else {
            throw new IOException("Parsin error." + CategorylinksParser.class.getName() + " returned null value in " + ((Object)((Object)this)).getClass().getName());
        }
    }

    public void processPageLinksRow(PagelinksParser plParser) throws IOException {
        int pl_from = plParser.getPlFrom();
        String pl_to = plParser.getPlTo();
        if (pl_to != null) {
            Object plToHash = this.hashAlgorithm.hashCode(pl_to);
            Integer pl_toValue = this.pNamePageIdMap.get(plToHash);
            if ((!this.skipPage || this.pPageIdNameMap.containsKey(pl_from)) && pl_toValue != null) {
                this.pageOutlinks.addRow(new Object[]{pl_from, pl_toValue});
                this.pageInlinks.addRow(new Object[]{pl_toValue, pl_from});
            }
        }
    }

    public void processPageRow(PageParser pageParser) throws IOException {
        int page_namespace = pageParser.getPageNamespace();
        int page_id = pageParser.getPageId();
        String page_title = pageParser.getPageTitle();
        if (page_title != null) {
            switch (page_namespace) {
                case 14: {
                    if (this.skipCategory && pageParser.getPageIsRedirect()) break;
                    this.cPageIdNameMap.add(page_id);
                    this.cNamePageIdMap.put(this.hashAlgorithm.hashCode(page_title), page_id);
                    this.txtFW.addRow(new Object[]{page_id, page_id, page_title});
                    break;
                }
                case 1: {
                    page_title = DISCUSSION_PREFIX + page_title;
                }
                case 0: {
                    if (pageParser.getPageIsRedirect()) {
                        this.rPageIdNameMap.put(page_id, page_title);
                        break;
                    }
                    this.pPageIdNameMap.put(page_id, page_title);
                    this.pNamePageIdMap.put(this.hashAlgorithm.hashCode(page_title), page_id);
                }
            }
        }
    }

    public void processRevisionRow(RevisionParser revisionParser) {
        this.textIdPageIdMap.put(revisionParser.getRevTextId(), revisionParser.getRevPage());
    }

    public void processTextRow(TextParser textParser) throws IOException {
        int text_id = textParser.getOldId();
        if (this.textIdPageIdMap.containsKey(text_id)) {
            int page_id = this.textIdPageIdMap.get(text_id);
            String page_idValueP = this.pPageIdNameMap.get(page_id);
            if (page_idValueP != null) {
                this.page.addRow(new Object[]{page_id, page_id, page_idValueP, textParser.getOldText(), this.formatBoolean(this.disambiguations.contains(page_id))});
                this.pageMapLine.addRow(new Object[]{page_id, page_idValueP, page_id, SQL_NULL, SQL_NULL});
            } else {
                Object destinationHash;
                Integer destinationValue;
                String destination;
                String page_idValueR = this.rPageIdNameMap.get(page_id);
                if (page_idValueR != null && (destination = Redirects.getRedirectDestination((String)textParser.getOldText())) != null && (destinationValue = this.pNamePageIdMap.get(destinationHash = this.hashAlgorithm.hashCode(destination))) != null) {
                    this.pageRedirects.addRow(new Object[]{destinationValue, page_idValueR});
                    this.pageMapLine.addRow(new Object[]{page_id, page_idValueR, destinationValue, SQL_NULL, SQL_NULL});
                    this.metaData.addRedirect();
                }
            }
        }
    }

    public void writeMetaData() throws IOException {
        TxtFileWriter outputFile = new TxtFileWriter(this.versionFiles.getOutputMetadata());
        outputFile.addRow(new Object[]{this.metaData.getId(), this.metaData.getLanguage(), this.metaData.getDisambiguationCategory(), this.metaData.getMainCategory(), this.metaData.getNrOfPages(), this.metaData.getNrOfRedirects(), this.metaData.getNrOfDisambiguations(), this.metaData.getNrOfCategories()});
        outputFile.flush();
        outputFile.close();
    }
}

