/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.datamachine.domain;

import de.tudarmstadt.ukp.wikipedia.datamachine.domain.DataMachineFiles;
import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.ILogger;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.Configuration;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.Files;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.ISnapshotGenerator;
import de.tudarmstadt.ukp.wikipedia.wikimachine.factory.IEnvironmentFactory;
import de.tudarmstadt.ukp.wikipedia.wikimachine.factory.SpringFactory;

public class JWPLDataMachine {
    private static final int LANG_ARG = 0;
    private static final int MAINCATEGORY_ARG = 1;
    private static final int DISAMBIGUATION_ARG = 2;
    private static final int DATADIR_ARG = 3;
    private static final String USAGE = "Please use\n\tjava -jar JWPLDataMachine.jar <LANGUAGE> <TOP_CATEGORY_NAME> <DISAMBIGUATION_CATEGORY_NAME> <SOURCE_DIRECTORY>\n\nThe source directory must contain files\n\tpagelinks.sql\n\tpages-articles.xml\n\tcategorylinks.sql\nGZip or BZip2 compressed archives of above-named files are also allowed.\nPlease set up a decompressor.xml for a usage of other external archive utilities (see documentation for more help).\n";
    private static final long startTime = System.currentTimeMillis();
    private static final IEnvironmentFactory environmentFactory = SpringFactory.getInstance();
    private static final ILogger logger = environmentFactory.getLogger();

    public static void main(String[] args) {
        if (args.length > 3) {
            Configuration config = JWPLDataMachine.getConfigFromArgs(args);
            DataMachineFiles files = new DataMachineFiles(logger);
            files.setDataDirectory(args[3]);
            if (files.checkAll()) {
                try {
                    ISnapshotGenerator generator = environmentFactory.getSnapshotGenerator();
                    generator.setConfiguration(config);
                    generator.setFiles((Files)files);
                    generator.start();
                    logger.log((Object)("End of the application. Working time = " + String.valueOf(System.currentTimeMillis() - startTime) + " ms"));
                }
                catch (Exception e) {
                    logger.log((Object)e);
                }
            } else {
                logger.log((Object)("Not all necessary source files could be found in " + args[3]));
            }
        } else {
            System.out.println(USAGE);
        }
    }

    private static Configuration getConfigFromArgs(String[] args) {
        Configuration config = new Configuration(logger);
        config.setLanguage(args[0]);
        config.setMainCategory(args[1]);
        config.setDisambiguationCategory(args[2]);
        return config;
    }
}

