/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.datamachine.domain;

import de.tudarmstadt.ukp.wikipedia.datamachine.domain.DataMachineFiles;
import de.tudarmstadt.ukp.wikipedia.datamachine.dump.xml.XML2Binary;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.AbstractSnapshotGenerator;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.Configuration;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.Files;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.MetaData;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.CategorylinksParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.sql.PagelinksParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.version.IDumpVersion;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.DumpTableEnum;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.DumpTableInputStream;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.PageParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.RevisionParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.dump.xml.TextParser;
import de.tudarmstadt.ukp.wikipedia.wikimachine.factory.IEnvironmentFactory;
import java.io.IOException;
import java.io.InputStream;

public class DataMachineGenerator
extends AbstractSnapshotGenerator {
    DataMachineFiles files = null;
    IDumpVersion version = null;

    public DataMachineGenerator(IEnvironmentFactory environmentFactory) {
        super(environmentFactory);
    }

    public void setFiles(Files files) {
        this.files = (DataMachineFiles)files;
    }

    public void start() throws Exception {
        this.version = this.environmentFactory.getDumpVersion();
        MetaData metaData = MetaData.initWithConfig((Configuration)this.configuration);
        this.version.initialize(null);
        this.version.setMetaData(metaData);
        this.version.setFiles((Files)this.files);
        this.processInputDump();
    }

    private void processInputDump() throws IOException {
        this.logger.log((Object)"parse input dumps...");
        new XML2Binary(this.decompressor.getInputStream(this.getPagesArticlesFile()), this.files);
        System.gc();
        this.dumpVersionProcessor.setDumpVersions(new IDumpVersion[]{this.version});
        this.logger.log((Object)"processing table page...");
        this.dumpVersionProcessor.processPage(this.createPageParser());
        this.logger.log((Object)"processing table categorylinks...");
        this.dumpVersionProcessor.processCategorylinks(this.createCategorylinksParser());
        this.logger.log((Object)"processing table pagelinks...");
        this.dumpVersionProcessor.processPagelinks(this.createPagelinksParser());
        this.logger.log((Object)"processing table revision...");
        this.dumpVersionProcessor.processRevision(this.createRevisionParser());
        this.logger.log((Object)"processing table text...");
        this.dumpVersionProcessor.processText(this.createTextParser());
        this.logger.log((Object)"writing metadata...");
        this.dumpVersionProcessor.writeMetaData();
        this.logger.log((Object)"finished");
    }

    private String getPagesArticlesFile() {
        String pagesArticlesFile = null;
        String parseMessage = null;
        if (this.files.getInputPagesArticles() != null) {
            pagesArticlesFile = this.files.getInputPagesArticles();
            parseMessage = "Discussions are unavailable";
        }
        if (this.files.getInputPagesMetaCurrent() != null) {
            pagesArticlesFile = this.files.getInputPagesMetaCurrent();
            parseMessage = "Discussions are available";
        }
        this.logger.log((Object)parseMessage);
        return pagesArticlesFile;
    }

    private PageParser createPageParser() throws IOException {
        String pageFile = this.files.getGeneratedPage();
        DumpTableInputStream pageTableInputStream = this.environmentFactory.getDumpTableInputStream();
        pageTableInputStream.initialize(this.decompressor.getInputStream(pageFile), DumpTableEnum.PAGE);
        PageParser pageParser = this.environmentFactory.getPageParser();
        pageParser.setInputStream((InputStream)pageTableInputStream);
        return pageParser;
    }

    private CategorylinksParser createCategorylinksParser() throws IOException {
        String categorylinksFile = this.files.getInputCategoryLinks();
        return new CategorylinksParser(this.decompressor.getInputStream(categorylinksFile));
    }

    private PagelinksParser createPagelinksParser() throws IOException {
        String pagelinksFile = this.files.getInputPageLinks();
        return new PagelinksParser(this.decompressor.getInputStream(pagelinksFile));
    }

    private RevisionParser createRevisionParser() throws IOException {
        String revisionFile = this.files.getGeneratedRevision();
        DumpTableInputStream revisionTableInputStream = this.environmentFactory.getDumpTableInputStream();
        revisionTableInputStream.initialize(this.decompressor.getInputStream(revisionFile), DumpTableEnum.REVISION);
        RevisionParser revisionParser = this.environmentFactory.getRevisionParser();
        revisionParser.setInputStream((InputStream)revisionTableInputStream);
        return revisionParser;
    }

    private TextParser createTextParser() throws IOException {
        String textFile = this.files.getGeneratedText();
        DumpTableInputStream textTableInputStream = this.environmentFactory.getDumpTableInputStream();
        textTableInputStream.initialize(this.decompressor.getInputStream(textFile), DumpTableEnum.TEXT);
        TextParser textParser = this.environmentFactory.getTextParser();
        textParser.setInputStream((InputStream)textTableInputStream);
        return textParser;
    }
}

