/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.datamachine.domain;

import de.tudarmstadt.ukp.wikipedia.wikimachine.debug.ILogger;
import de.tudarmstadt.ukp.wikipedia.wikimachine.domain.Files;
import java.io.File;

public class DataMachineFiles
extends Files {
    private static final String INPUT_PAGELINKS = "pagelinks.sql";
    private static final String INPUT_PAGESARTICLES = "pages-articles.xml";
    private static final String INPUT_CATEGORYLINKS = "categorylinks.sql";
    private static final String INPUT_PAGESMETACURRENT = "pages-meta-current.xml";
    private static final String GENERATED_PAGE = "page.bin";
    private static final String GENERATED_REVISION = "revision.bin";
    private static final String GENERATED_TEXT = "text.bin";
    private static final String GENERATED_DISCUSSIONS = "discussions.bin";
    private static final String ARCHIVE_EXTENSION = ".gz";
    private File dataDirectory = new File(".");
    private boolean compressGeneratedFiles = false;
    private File inputPagelinks = null;
    private File inputPagesarticles = null;
    private File inputCategorylinks = null;
    private File inputPagesMetaCurrent = null;

    public DataMachineFiles(ILogger logger) {
        super(logger);
        this.outputDirectory = this.setOutputDirectory(this.dataDirectory);
    }

    public DataMachineFiles(DataMachineFiles files) {
        super((Files)files);
        this.dataDirectory = files.dataDirectory;
        this.compressGeneratedFiles = files.compressGeneratedFiles;
        this.inputPagelinks = files.inputPagelinks;
        this.inputPagesarticles = files.inputPagesarticles;
        this.inputCategorylinks = files.inputCategorylinks;
        this.inputPagesMetaCurrent = files.inputPagesMetaCurrent;
    }

    private File setOutputDirectory(File parentDirectory) {
        File result = new File(parentDirectory.getAbsolutePath() + File.separator + "output");
        return result;
    }

    public void setDataDirectory(String newDataDirectory) {
        File inputDataDirectory = new File(newDataDirectory);
        if (inputDataDirectory.isDirectory()) {
            this.dataDirectory = inputDataDirectory;
            this.outputDirectory = this.setOutputDirectory(this.dataDirectory);
        } else {
            this.logger.log((Object)(this.dataDirectory + " is not a directory. Continue read from " + this.dataDirectory.getAbsolutePath()));
        }
    }

    public boolean checkDatamachineSourceFiles() {
        File[] filesInDataDirectory = this.dataDirectory.listFiles();
        if (filesInDataDirectory.length > 2) {
            for (File currentFile : filesInDataDirectory) {
                String currentFileName = currentFile.getName();
                if (currentFileName.contains(INPUT_PAGESARTICLES)) {
                    this.inputPagesarticles = currentFile;
                    continue;
                }
                if (currentFileName.contains(INPUT_PAGELINKS)) {
                    this.inputPagelinks = currentFile;
                    continue;
                }
                if (currentFileName.contains(INPUT_CATEGORYLINKS)) {
                    this.inputCategorylinks = currentFile;
                    continue;
                }
                if (!currentFileName.contains(INPUT_PAGESMETACURRENT)) continue;
                this.inputPagesMetaCurrent = currentFile;
            }
        }
        return (this.inputPagesarticles != null || this.inputPagesMetaCurrent != null) && this.inputPagelinks != null && this.inputCategorylinks != null;
    }

    public String getGeneratedPage() {
        return this.getGeneratedPath(GENERATED_PAGE);
    }

    public String getGeneratedRevision() {
        return this.getGeneratedPath(GENERATED_REVISION);
    }

    public String getGeneratedText() {
        return this.getGeneratedPath(GENERATED_TEXT);
    }

    public String getGeneratedDiscussions() {
        return this.getGeneratedPath(GENERATED_DISCUSSIONS);
    }

    public String getInputPageLinks() {
        return this.inputPagelinks != null ? this.inputPagelinks.getAbsolutePath() : null;
    }

    public String getInputPagesArticles() {
        return this.inputPagesarticles != null ? this.inputPagesarticles.getAbsolutePath() : null;
    }

    public String getInputCategoryLinks() {
        return this.inputCategorylinks != null ? this.inputCategorylinks.getAbsolutePath() : null;
    }

    public String getInputPagesMetaCurrent() {
        return this.inputPagesMetaCurrent != null ? this.inputPagesMetaCurrent.getAbsolutePath() : null;
    }

    private String getGeneratedPath(String fileName) {
        String path = this.dataDirectory.getAbsolutePath() + File.separator + fileName;
        if (this.compressGeneratedFiles) {
            path = path.concat(ARCHIVE_EXTENSION);
        }
        return path;
    }

    public boolean isCompressGeneratedFiles() {
        return this.compressGeneratedFiles;
    }

    public void setCompressGeneratedFiles(boolean compressGeneratedFiles) {
        this.compressGeneratedFiles = compressGeneratedFiles;
    }

    public boolean checkAll() {
        return this.checkOutputDirectory() && this.checkDatamachineSourceFiles();
    }
}

