/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class UnmodifiableArraySet<E>
implements Set<E> {
    private Object[] data;

    public UnmodifiableArraySet(E[] aData) {
        this.data = new Object[aData.length];
        System.arraycopy(aData, 0, this.data, 0, this.data.length);
    }

    public UnmodifiableArraySet(Set<E> aData) {
        this.data = new Object[aData.size()];
        System.arraycopy(aData.toArray(), 0, this.data, 0, this.data.length);
    }

    @Override
    public int size() {
        return this.data != null ? this.data.length : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.data != null ? this.data.length > 0 : true;
    }

    @Override
    public boolean contains(Object aO) {
        if (this.data == null) {
            return false;
        }
        for (Object d : this.data) {
            if (!d.equals(aO)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.data).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.data;
    }

    @Override
    public <T> T[] toArray(T[] aA) {
        if (aA.length != this.data.length) {
            throw new IllegalArgumentException("Target array too small");
        }
        System.arraycopy(this.data, 0, aA, 0, aA.length);
        return aA;
    }

    @Override
    public boolean add(E aE) {
        throw new UnsupportedOperationException("Unmodifiable set");
    }

    @Override
    public boolean remove(Object aO) {
        throw new UnsupportedOperationException("Unmodifiable set");
    }

    @Override
    public boolean containsAll(Collection<?> aC) {
        for (Object o : aC) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> aC) {
        throw new UnsupportedOperationException("Unmodifiable set");
    }

    @Override
    public boolean retainAll(Collection<?> aC) {
        throw new UnsupportedOperationException("Unmodifiable set");
    }

    @Override
    public boolean removeAll(Collection<?> aC) {
        throw new UnsupportedOperationException("Unmodifiable set");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Unmodifiable set");
    }
}

