/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringUtils {
    private static final Log logger = LogFactory.getLog(StringUtils.class);

    public static String join(Collection c, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String getFileContent(String filename, String encoding) {
        File file = new File(filename);
        String textContents = "";
        try {
            FileInputStream is = new FileInputStream(file);
            byte[] contents = new byte[(int)file.length()];
            ((InputStream)is).read(contents);
            textContents = new String(contents, encoding);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("File " + file.getAbsolutePath() + " not found."));
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error((Object)("IO exception while reading file " + file.getAbsolutePath()));
            e.printStackTrace();
        }
        return textContents;
    }

    public static String sqlEscape(String str) {
        int len = str.length();
        StringBuilder sql = new StringBuilder(len * 2);
        block11: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    sql.append('\\').append('0');
                    continue block11;
                }
                case '\n': {
                    sql.append('\\').append('n');
                    continue block11;
                }
                case '\t': {
                    sql.append('\\').append('t');
                    continue block11;
                }
                case '\r': {
                    sql.append('\\').append('r');
                    continue block11;
                }
                case '\u001a': {
                    sql.append('\\').append('Z');
                    continue block11;
                }
                case '\'': {
                    sql.append('\\').append('\'');
                    continue block11;
                }
                case '\"': {
                    sql.append('\\').append('\"');
                    continue block11;
                }
                case '\b': {
                    sql.append('\\').append('b');
                    continue block11;
                }
                case '\\': {
                    sql.append('\\').append('\\');
                    continue block11;
                }
                default: {
                    sql.append(c);
                }
            }
        }
        return sql.toString();
    }
}

