/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.wikipedia.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbUtilities {
    private Connection conn;
    private final Log logger = LogFactory.getLog(this.getClass());

    public DbUtilities(Connection conn) {
        this.conn = conn;
    }

    public boolean tableExists(String tableName) {
        try {
            DatabaseMetaData dbmd = this.conn.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet resultSet = dbmd.getTables(null, null, "%", types);
            while (resultSet.next()) {
                if (!resultSet.getString("TABLE_NAME").equals(tableName)) continue;
                return true;
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("Table " + tableName + " does not exist."), new Throwable());
        }
        return false;
    }
}

